/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph;

import gov.sandia.cognition.collection.DoubleArrayList;
import gov.sandia.cognition.graph.DenseMemoryGraph;
import gov.sandia.cognition.graph.DirectedWeightedNodeEdgeGraph;
import gov.sandia.cognition.util.DefaultKeyValuePair;
import gov.sandia.cognition.util.Pair;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;

public class WeightedDenseMemoryGraph<NodeNameType>
extends DenseMemoryGraph<NodeNameType>
implements DirectedWeightedNodeEdgeGraph<NodeNameType> {
    private static final long serialVersionUID = 9009145019650654200L;
    private DoubleArrayList weights;

    public WeightedDenseMemoryGraph() {
        this(5, 10);
    }

    public WeightedDenseMemoryGraph(int expectedNumNodes, int expectedNumEdges) {
        super(expectedNumNodes, expectedNumEdges);
        this.weights = new DoubleArrayList(expectedNumEdges);
    }

    @Override
    public void addEdge(NodeNameType left, NodeNameType right) {
        this.addEdge(left, right, 1.0);
    }

    @Override
    public void addEdge(NodeNameType left, NodeNameType right, double weight) {
        super.addEdge(left, right);
        this.weights.add(weight);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        this.weights.swap(i, j);
    }

    @Override
    public Collection<Pair<NodeNameType, Double>> getSuccessorsWithWeights(NodeNameType node) {
        HashSet<Pair<NodeNameType, Double>> ret = new HashSet<Pair<NodeNameType, Double>>();
        int nodeId = this.getNodeId(node);
        int m = this.getNumEdges();
        int idx0 = this.getFirstEdgeFrom(nodeId);
        if (idx0 >= 0 && idx0 <= m) {
            for (int i = idx0; i < m; ++i) {
                Pair<Integer, Integer> endPts = this.getEdgeEndpointIds(i);
                if ((Integer)endPts.getFirst() == nodeId) {
                    ret.add((Pair<NodeNameType, Double>)new DefaultKeyValuePair(this.getNode((Integer)endPts.getSecond()), (Object)this.weights.get(i)));
                    continue;
                }
                if ((Integer)endPts.getFirst() > nodeId) break;
            }
        }
        return ret;
    }

    @Override
    public double getEdgeWeight(int id) {
        this.optimizeEdges();
        return this.weights.get(id);
    }

    @Override
    public void clear() {
        super.clear();
        this.weights.clear();
    }

    public static void serialize(String fileName, WeightedDenseMemoryGraph<?> graph) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(fileName));){
            out.writeObject(graph);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static WeightedDenseMemoryGraph<?> deserialize(String fileName) {
        WeightedDenseMemoryGraph graph = null;
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));){
            graph = (WeightedDenseMemoryGraph)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return graph;
    }
}

