/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.DoubleArrayList;
import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.util.DefaultKeyValuePair;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;

public class GraphMetrics<NodeNameType> {
    private final DirectedNodeEdgeGraph<NodeNameType> graph;
    private List<Set<Integer>> allNodeNeighbors;
    private List<Set<Integer>> allNodeSuccessors;
    private IntArrayList allNodeDegrees;
    private List<Set<Pair<Integer, Integer>>> allNodeTriangles;
    private double degreeAssortativity;
    private DoubleArrayList perEdgeJaccardSimilarity;
    private List<Set<Integer>> allEdgeTriangles;
    private DoubleArrayList perEdgeTriangleDensity;
    private IntArrayList perNodeEccentricity;
    private DoubleArrayList perNodeBetweenCentrality;
    private int radius;
    private int diameter;
    private Boolean isWcc;

    public GraphMetrics(DirectedNodeEdgeGraph<NodeNameType> graph) {
        this.graph = graph;
        this.allNodeNeighbors = null;
        this.allNodeSuccessors = null;
        this.allNodeDegrees = null;
        this.allNodeTriangles = null;
        this.degreeAssortativity = -1.7976931348623157E308;
        this.perEdgeJaccardSimilarity = null;
        this.allEdgeTriangles = null;
        this.perEdgeTriangleDensity = null;
        this.diameter = Integer.MAX_VALUE;
        this.radius = Integer.MAX_VALUE;
        this.perNodeEccentricity = null;
        this.perNodeBetweenCentrality = null;
        this.isWcc = null;
    }

    public void clear() {
        this.allNodeNeighbors = null;
        this.allNodeSuccessors = null;
        this.allNodeDegrees = null;
        this.allNodeTriangles = null;
        this.degreeAssortativity = -1.7976931348623157E308;
        this.perEdgeJaccardSimilarity = null;
        this.allEdgeTriangles = null;
        this.perEdgeTriangleDensity = null;
        this.diameter = Integer.MAX_VALUE;
        this.radius = Integer.MAX_VALUE;
        this.perNodeEccentricity = null;
        this.isWcc = null;
    }

    public int numNodes() {
        return this.graph.getNumNodes();
    }

    public int numEdges() {
        return this.graph.getNumEdges();
    }

    private boolean isInitializedNodeDegrees() {
        return this.allNodeDegrees != null;
    }

    public void initializeNodeDegrees() {
        int n = this.numNodes();
        this.allNodeDegrees = new IntArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.allNodeDegrees.add(0);
        }
        int m = this.numEdges();
        for (int i = 0; i < m; ++i) {
            Pair<Integer, Integer> edge = this.graph.getEdgeEndpointIds(i);
            this.allNodeDegrees.plusEquals(((Integer)edge.getFirst()).intValue(), 1);
            this.allNodeDegrees.plusEquals(((Integer)edge.getSecond()).intValue(), 1);
        }
    }

    public int degree(int nodeId) {
        if (!this.isInitializedNodeDegrees()) {
            this.initializeNodeDegrees();
        }
        return this.allNodeDegrees.get(nodeId);
    }

    public int degree(NodeNameType nodeName) {
        return this.degree(this.graph.getNodeId(nodeName));
    }

    private boolean isInitializedNodeNeighbors() {
        return this.allNodeNeighbors != null;
    }

    public void initializeNodeNeighbors() {
        if (!this.isInitializedNodeDegrees()) {
            this.initializeNodeDegrees();
        }
        int n = this.numNodes();
        this.allNodeNeighbors = new ArrayList<Set<Integer>>(n);
        for (int i = 0; i < n; ++i) {
            int di = this.degree(i);
            this.allNodeNeighbors.add(new HashSet(di));
        }
        int m = this.numEdges();
        for (int i = 0; i < m; ++i) {
            Pair<Integer, Integer> e = this.graph.getEdgeEndpointIds(i);
            this.allNodeNeighbors.get((Integer)e.getFirst()).add((Integer)e.getSecond());
            this.allNodeNeighbors.get((Integer)e.getSecond()).add((Integer)e.getFirst());
        }
    }

    public int numNeighbors(int nodeId) {
        if (!this.isInitializedNodeNeighbors()) {
            this.initializeNodeNeighbors();
        }
        return this.allNodeNeighbors.get(nodeId).size();
    }

    public int numNeighbors(NodeNameType nodeName) {
        return this.numNeighbors(this.graph.getNodeId(nodeName));
    }

    public Set<Integer> neighborIds(int nodeId) {
        if (!this.isInitializedNodeNeighbors()) {
            this.initializeNodeNeighbors();
        }
        return Collections.unmodifiableSet(this.allNodeNeighbors.get(nodeId));
    }

    public Set<Integer> neighborIds(NodeNameType nodeName) {
        return this.neighborIds((NodeNameType)this.graph.getNodeId(nodeName));
    }

    public Set<NodeNameType> neighbors(int nodeId) {
        Set<Integer> ids = this.neighborIds((NodeNameType)nodeId);
        HashSet<NodeNameType> ret = new HashSet<NodeNameType>(ids.size());
        for (Integer id : ids) {
            ret.add(this.graph.getNode(id));
        }
        return ret;
    }

    public Set<NodeNameType> neighbors(NodeNameType nodeName) {
        return this.neighbors((NodeNameType)this.graph.getNodeId(nodeName));
    }

    private boolean isInitializedNodeSuccessors() {
        return this.allNodeSuccessors != null;
    }

    public void initializeNodeSuccessors() {
        int n = this.numNodes();
        this.allNodeSuccessors = new ArrayList<Set<Integer>>(n);
        for (int i = 0; i < n; ++i) {
            this.allNodeSuccessors.add(new HashSet());
        }
        int m = this.numEdges();
        for (int i = 0; i < m; ++i) {
            Pair<Integer, Integer> e = this.graph.getEdgeEndpointIds(i);
            this.allNodeSuccessors.get((Integer)e.getFirst()).add((Integer)e.getSecond());
        }
    }

    public int numSuccessors(int nodeId) {
        if (!this.isInitializedNodeSuccessors()) {
            this.initializeNodeSuccessors();
        }
        return this.allNodeSuccessors.get(nodeId).size();
    }

    public int numSuccessors(NodeNameType nodeName) {
        return this.numSuccessors(this.graph.getNodeId(nodeName));
    }

    public Set<Integer> successorIds(int nodeId) {
        if (!this.isInitializedNodeSuccessors()) {
            this.initializeNodeSuccessors();
        }
        return Collections.unmodifiableSet(this.allNodeSuccessors.get(nodeId));
    }

    public Set<Integer> successorIds(NodeNameType nodeName) {
        return this.successorIds((NodeNameType)this.graph.getNodeId(nodeName));
    }

    public Set<NodeNameType> successors(int nodeId) {
        Set<Integer> ids = this.successorIds((NodeNameType)nodeId);
        HashSet<NodeNameType> ret = new HashSet<NodeNameType>(ids.size());
        for (Integer id : ids) {
            ret.add(this.graph.getNode(id));
        }
        return ret;
    }

    public Set<NodeNameType> successors(NodeNameType nodeName) {
        return this.successors((NodeNameType)this.graph.getNodeId(nodeName));
    }

    private boolean isInitializedNodeTriangles() {
        return this.allNodeTriangles != null;
    }

    @PublicationReference(author={"Siddharth Suri and Sergei Vassilvitskii"}, title="Counting Triangles and the Curse of the Last Reducer", year=2011, publication="Proceedings of the World Wide Web Conference (WWW)", type=PublicationType.Conference)
    public void initializeNodeTriangles() {
        int i;
        int i2;
        if (!this.isInitializedNodeDegrees()) {
            this.initializeNodeDegrees();
        }
        if (!this.isInitializedNodeNeighbors()) {
            this.initializeNodeNeighbors();
        }
        int n = this.numNodes();
        int m = this.numEdges();
        ArrayList<DefaultKeyValuePair> degreeList = new ArrayList<DefaultKeyValuePair>(n);
        for (int i3 = 0; i3 < n; ++i3) {
            degreeList.add(new DefaultKeyValuePair((Object)i3, (Object)this.degree(i3)));
        }
        Collections.sort(degreeList, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                return Integer.compare((Integer)o1.getSecond(), (Integer)o2.getSecond());
            }
        });
        ArrayList<Integer> nodeOrder = new ArrayList<Integer>(n);
        for (i2 = 0; i2 < n; ++i2) {
            nodeOrder.add(0);
        }
        for (i2 = 0; i2 < n; ++i2) {
            nodeOrder.set((Integer)((Pair)degreeList.get(i2)).getFirst(), i2);
        }
        HashMap edgeMap = new HashMap(2 * m);
        this.allEdgeTriangles = new ArrayList<Set<Integer>>(m);
        for (i = 0; i < m; ++i) {
            Pair<Integer, Integer> edge = this.graph.getEdgeEndpointIds(i);
            this.allEdgeTriangles.add(new HashSet());
            if (!edgeMap.containsKey(edge)) {
                edgeMap.put(edge, new HashSet());
            }
            ((Set)edgeMap.get(edge)).add(i);
            DefaultKeyValuePair otherOrder = new DefaultKeyValuePair(edge.getSecond(), edge.getFirst());
            if (!edgeMap.containsKey(otherOrder)) {
                edgeMap.put(otherOrder, new HashSet());
            }
            ((Set)edgeMap.get(otherOrder)).add(i);
        }
        this.allNodeTriangles = new ArrayList<Set<Pair<Integer, Integer>>>(n);
        for (i = 0; i < n; ++i) {
            this.allNodeTriangles.add(new HashSet());
        }
        for (i = 0; i < n; ++i) {
            if (this.degree(i) <= 1) continue;
            int iidx = (Integer)nodeOrder.get(i);
            int jcnt = 0;
            for (Integer neighborj : this.allNodeNeighbors.get(i)) {
                ++jcnt;
                if (i == neighborj || iidx > (Integer)nodeOrder.get(neighborj)) continue;
                int kcnt = 0;
                for (Integer neighbork : this.allNodeNeighbors.get(i)) {
                    int edgeId;
                    if (i == neighbork || ++kcnt <= jcnt || iidx > (Integer)nodeOrder.get(neighbork) || !this.allNodeNeighbors.get(neighborj).contains(neighbork)) continue;
                    this.allNodeTriangles.get(i).add((Pair<Integer, Integer>)new DefaultKeyValuePair((Object)neighborj, (Object)neighbork));
                    this.allNodeTriangles.get(neighborj).add((Pair<Integer, Integer>)new DefaultKeyValuePair((Object)i, (Object)neighbork));
                    this.allNodeTriangles.get(neighbork).add((Pair<Integer, Integer>)new DefaultKeyValuePair((Object)i, (Object)neighborj));
                    DefaultKeyValuePair edge = new DefaultKeyValuePair((Object)i, (Object)neighborj);
                    Iterator iterator = ((Set)edgeMap.get(edge)).iterator();
                    while (iterator.hasNext()) {
                        edgeId = (Integer)iterator.next();
                        this.allEdgeTriangles.get(edgeId).add(neighbork);
                    }
                    edge = new DefaultKeyValuePair((Object)i, (Object)neighbork);
                    iterator = ((Set)edgeMap.get(edge)).iterator();
                    while (iterator.hasNext()) {
                        edgeId = (Integer)iterator.next();
                        this.allEdgeTriangles.get(edgeId).add(neighborj);
                    }
                    edge = new DefaultKeyValuePair((Object)neighborj, (Object)neighbork);
                    iterator = ((Set)edgeMap.get(edge)).iterator();
                    while (iterator.hasNext()) {
                        edgeId = (Integer)iterator.next();
                        this.allEdgeTriangles.get(edgeId).add(i);
                    }
                }
            }
        }
    }

    public int numNodeTriangles(int nodeId) {
        if (!this.isInitializedNodeTriangles()) {
            this.initializeNodeTriangles();
        }
        return this.allNodeTriangles.get(nodeId).size();
    }

    public int numNodeTriangles(NodeNameType nodeName) {
        return this.numNodeTriangles(this.graph.getNodeId(nodeName));
    }

    public Set<Pair<Integer, Integer>> getNodeTriangleEndpointIds(int nodeId) {
        if (!this.isInitializedNodeTriangles()) {
            this.initializeNodeTriangles();
        }
        return Collections.unmodifiableSet(this.allNodeTriangles.get(nodeId));
    }

    public Set<Pair<Integer, Integer>> getNodeTriangleEndpointIds(NodeNameType nodeName) {
        return this.getNodeTriangleEndpointIds((NodeNameType)this.graph.getNodeId(nodeName));
    }

    public Set<Pair<NodeNameType, NodeNameType>> getNodeTriangleEndpoints(int nodeId) {
        Set<Pair<Integer, Integer>> endpointIds = this.getNodeTriangleEndpointIds((NodeNameType)nodeId);
        HashSet<Pair<NodeNameType, NodeNameType>> ret = new HashSet<Pair<NodeNameType, NodeNameType>>(endpointIds.size());
        for (Pair<Integer, Integer> endpointId : endpointIds) {
            ret.add((Pair<NodeNameType, NodeNameType>)new DefaultKeyValuePair(this.graph.getNode((Integer)endpointId.getFirst()), this.graph.getNode((Integer)endpointId.getSecond())));
        }
        return ret;
    }

    public Set<Pair<NodeNameType, NodeNameType>> getNodeTriangleEndpoints(NodeNameType nodeName) {
        return this.getNodeTriangleEndpoints((NodeNameType)this.graph.getNodeId(nodeName));
    }

    private boolean isInitializedDegreeAssortativity() {
        return this.degreeAssortativity != -1.7976931348623157E308;
    }

    @PublicationReference(author={"M. E. J. Newman"}, title="Assortative mixing in networks", type=PublicationType.Journal, year=2002, publication="Physical Review Letters")
    public void initializeDegreeAssortativity() {
        if (!this.isInitializedNodeDegrees()) {
            this.initializeNodeDegrees();
        }
        int m = this.numEdges();
        double mInv = 1.0 / (double)m;
        double normalizeSumSquares = 0.0;
        double normalizeSum = 0.0;
        double numerProduct = 0.0;
        boolean allDegreesEqual = true;
        for (int i = 0; i < m; ++i) {
            double dj;
            Pair<Integer, Integer> edge = this.graph.getEdgeEndpointIds(i);
            double di = this.degree((Integer)edge.getFirst());
            allDegreesEqual &= di == (dj = (double)this.degree((Integer)edge.getSecond()));
            numerProduct += di * dj;
            normalizeSum += di + dj;
            normalizeSumSquares += di * di + dj * dj;
        }
        if (allDegreesEqual) {
            this.degreeAssortativity = 1.0;
            return;
        }
        normalizeSum *= normalizeSum;
        this.degreeAssortativity = (numerProduct - (normalizeSum *= mInv * 0.25)) / (0.5 * normalizeSumSquares - normalizeSum);
    }

    public double degreeAssortativity() {
        if (!this.isInitializedDegreeAssortativity()) {
            this.initializeDegreeAssortativity();
        }
        return this.degreeAssortativity;
    }

    private boolean isInitializedPerEdgeJaccardSimilarity() {
        return this.perEdgeJaccardSimilarity != null;
    }

    @PublicationReference(title="Jaccard index", type=PublicationType.WebPage, year=2015, author={"Wikipedia"}, url="https://en.wikipedia.org/wiki/Jaccard_index")
    public void initializePerEdgeJaccardSimilarity() {
        if (!this.isInitializedNodeNeighbors()) {
            this.initializeNodeNeighbors();
        }
        int m = this.numEdges();
        this.perEdgeJaccardSimilarity = new DoubleArrayList(m);
        for (int i = 0; i < m; ++i) {
            Pair<Integer, Integer> edge = this.graph.getEdgeEndpointIds(i);
            HashSet<Integer> iNeighbors = new HashSet<Integer>(this.neighborIds((NodeNameType)((Integer)edge.getFirst())));
            Set<Integer> jNeighbors = this.neighborIds((NodeNameType)((Integer)edge.getSecond()));
            int iSize = iNeighbors.size();
            int jSize = jNeighbors.size();
            iNeighbors.retainAll(jNeighbors);
            int intersectSize = iNeighbors.size();
            this.perEdgeJaccardSimilarity.add((double)intersectSize / (double)(iSize + jSize - intersectSize));
        }
    }

    public double getEdgeJaccardSimilarity(int edgeId) {
        if (!this.isInitializedPerEdgeJaccardSimilarity()) {
            this.initializePerEdgeJaccardSimilarity();
        }
        return this.perEdgeJaccardSimilarity.get(edgeId);
    }

    private boolean isInitializedEdgeTriangles() {
        return this.allEdgeTriangles != null;
    }

    public void initializeEdgeTriangles() {
        this.initializeNodeTriangles();
    }

    public int numEdgeTriangles(int edgeId) {
        if (!this.isInitializedEdgeTriangles()) {
            this.initializeEdgeTriangles();
        }
        return this.allEdgeTriangles.get(edgeId).size();
    }

    public Set<Integer> getEdgeTriangleOtherEndpointIds(int edgeId) {
        if (!this.isInitializedEdgeTriangles()) {
            this.initializeEdgeTriangles();
        }
        return Collections.unmodifiableSet(this.allEdgeTriangles.get(edgeId));
    }

    public Set<NodeNameType> getEdgeTriangleOtherEndpointNames(int edgeId) {
        Set<Integer> ids = this.getEdgeTriangleOtherEndpointIds(edgeId);
        HashSet<NodeNameType> ret = new HashSet<NodeNameType>(ids.size());
        for (Integer id : ids) {
            ret.add(this.graph.getNode(id));
        }
        return ret;
    }

    private boolean isInitializedPerEdgeTriangleDensity() {
        return this.perEdgeTriangleDensity != null;
    }

    public void initializePerEdgeTriangleDensity() {
        if (!this.isInitializedEdgeTriangles()) {
            this.initializeEdgeTriangles();
        }
        if (!this.isInitializedNodeDegrees()) {
            this.initializeNodeDegrees();
        }
        int m = this.numEdges();
        this.perEdgeTriangleDensity = new DoubleArrayList(m);
        for (int i = 0; i < m; ++i) {
            Pair<Integer, Integer> edge = this.graph.getEdgeEndpointIds(i);
            int di = this.degree((Integer)edge.getFirst());
            int dj = this.degree((Integer)edge.getSecond());
            double density = 2.0 * (double)this.numEdgeTriangles(i) / (double)(di + dj - 2);
            this.perEdgeTriangleDensity.add(density);
        }
    }

    public double getPerEdgeTriangleDensity(int edgeId) {
        if (!this.isInitializedPerEdgeTriangleDensity()) {
            this.initializePerEdgeTriangleDensity();
        }
        return this.perEdgeTriangleDensity.get(edgeId);
    }

    private boolean isInitializedPerNodeEccentricity() {
        return this.perNodeEccentricity != null;
    }

    @PublicationReference(author={"Frank W. Takes and Walter A. Kosters"}, title="Computing the Eccentricity Distribution of Large Graphs", type=PublicationType.Journal, publication="Algorithms - Open Access Journal", year=2013, pages={100, 118}, url="http://www.mdpi.com/1999-4893/6/1/100")
    public void initializePerNodeEccentricity() {
        int i;
        if (!this.isInitializedNodeNeighbors()) {
            this.initializeNodeNeighbors();
        }
        if (!this.isInitializedNodeDegrees()) {
            this.initializeNodeDegrees();
        }
        int n = this.numNodes();
        this.perNodeEccentricity = new IntArrayList(n);
        int[] minEccentricity = new int[n];
        int[] maxEccentricity = new int[n];
        this.radius = Integer.MAX_VALUE;
        this.diameter = Integer.MIN_VALUE;
        this.isWcc = true;
        HashSet<Integer> unvisitedNodes = new HashSet<Integer>(n);
        for (i = 0; i < n; ++i) {
            this.perNodeEccentricity.add(Integer.MAX_VALUE);
            minEccentricity[i] = Integer.MIN_VALUE;
            maxEccentricity[i] = Integer.MAX_VALUE;
            if (this.degree(i) <= 1) continue;
            unvisitedNodes.add(i);
        }
        if (n == 1) {
            this.perNodeEccentricity.set(0, 0);
        } else if (n == 2 && this.numEdges() >= 1) {
            this.perNodeEccentricity.set(0, 1);
            this.perNodeEccentricity.set(1, 1);
        }
        while (!unvisitedNodes.isEmpty()) {
            int v = (Integer)unvisitedNodes.iterator().next();
            unvisitedNodes.remove(v);
            int[] allDistances = this.computeAllDistancesForNode(v);
            int e_v = 0;
            for (int j = 0; j < n; ++j) {
                if (allDistances[j] == Integer.MAX_VALUE) {
                    this.isWcc = false;
                    continue;
                }
                e_v = Math.max(e_v, allDistances[j]);
            }
            if (e_v > maxEccentricity[v] || e_v < minEccentricity[v]) {
                throw new RuntimeException("This should be impossible.  Please report bug.");
            }
            this.perNodeEccentricity.set(v, e_v);
            this.radius = Math.min(this.radius, e_v);
            this.diameter = Math.max(this.diameter, e_v);
            for (int neighbor : this.neighborIds((NodeNameType)v)) {
                if (neighbor == v || this.degree(neighbor) != 1) continue;
                this.perNodeEccentricity.set(neighbor, e_v + 1);
                this.diameter = Math.max(this.diameter, e_v + 1);
            }
            Iterator iter = unvisitedNodes.iterator();
            while (iter.hasNext()) {
                int node = (Integer)iter.next();
                if (allDistances[node] == Integer.MAX_VALUE) continue;
                minEccentricity[node] = Math.max(minEccentricity[node], Math.max(e_v - allDistances[node], allDistances[node]));
                maxEccentricity[node] = Math.min(maxEccentricity[node], e_v + allDistances[node]);
                if (minEccentricity[node] != maxEccentricity[node]) continue;
                this.perNodeEccentricity.set(node, minEccentricity[node]);
                this.radius = Math.min(this.radius, minEccentricity[node]);
                this.diameter = Math.max(this.diameter, minEccentricity[node]);
                iter.remove();
            }
        }
        for (i = 0; i < this.perNodeEccentricity.size(); ++i) {
            if (this.perNodeEccentricity.get(i) != Integer.MAX_VALUE) continue;
            if (this.degree(i) == 1 && this.neighborIds((NodeNameType)i).iterator().next() != i) {
                this.perNodeEccentricity.set(i, 1);
                continue;
            }
            if (this.degree(i) == 0) {
                this.perNodeEccentricity.set(i, 0);
                continue;
            }
            throw new RuntimeException("Found node " + i + " has degree " + this.degree(i) + ", but never visited?  Please report bug with this exception and example graph");
        }
        if (!this.isWcc.booleanValue()) {
            this.radius = Integer.MAX_VALUE;
            this.diameter = Integer.MAX_VALUE;
        }
    }

    @PublicationReference(author={"Wikipedia"}, title="Dijkstra's algorithm", type=PublicationType.WebPage, url="https://en.wikipedia.org/wiki/Dijkstra%27s_algorithm", year=2016)
    public int[] computeAllDistancesForNode(int nodeId) {
        PriorityQueue<Pair<Integer, Integer>> queue = new PriorityQueue<Pair<Integer, Integer>>(new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                return Integer.compare((Integer)o1.getSecond(), (Integer)o2.getSecond());
            }
        });
        int n = this.numNodes();
        int[] allDistances = new int[n];
        boolean[] allDone = new boolean[n];
        for (int i = 0; i < n; ++i) {
            allDistances[i] = Integer.MAX_VALUE;
            allDone[i] = false;
        }
        int current = nodeId;
        allDistances[current] = 0;
        queue.add((Pair<Integer, Integer>)new DefaultKeyValuePair((Object)current, (Object)allDistances[current]));
        while (!queue.isEmpty()) {
            Pair<Integer, Integer> curr = queue.poll();
            while (allDone[(Integer)curr.getFirst()] && !queue.isEmpty()) {
                curr = queue.poll();
            }
            if (queue.isEmpty() && allDone[(Integer)curr.getFirst()]) break;
            allDone[((Integer)curr.getFirst()).intValue()] = true;
            int newLen = (Integer)curr.getSecond() + 1;
            for (int neighbor : this.neighborIds((NodeNameType)((Integer)curr.getFirst()))) {
                if (allDistances[neighbor] == Integer.MAX_VALUE) {
                    allDistances[neighbor] = newLen;
                    queue.add((Pair<Integer, Integer>)new DefaultKeyValuePair((Object)neighbor, (Object)allDistances[neighbor]));
                    continue;
                }
                if (allDistances[neighbor] <= newLen) continue;
                allDistances[neighbor] = newLen;
                queue.add((Pair<Integer, Integer>)new DefaultKeyValuePair((Object)neighbor, (Object)allDistances[neighbor]));
            }
        }
        return allDistances;
    }

    public int getPerNodeEccentricityById(int nodeId) {
        if (!this.isInitializedPerNodeEccentricity()) {
            this.initializePerNodeEccentricity();
        }
        return this.perNodeEccentricity.get(nodeId);
    }

    public int getPerNodeEccentricity(NodeNameType node) {
        if (!this.isInitializedPerNodeEccentricity()) {
            this.initializePerNodeEccentricity();
        }
        return this.perNodeEccentricity.get(this.graph.getNodeId(node));
    }

    public int getRadius() {
        if (!this.isInitializedPerNodeEccentricity()) {
            this.initializePerNodeEccentricity();
        }
        return this.radius;
    }

    public int getDiameter() {
        if (!this.isInitializedPerNodeEccentricity()) {
            this.initializePerNodeEccentricity();
        }
        return this.diameter;
    }

    public boolean isWcc() {
        if (!this.isInitializedPerNodeEccentricity()) {
            this.initializePerNodeEccentricity();
        }
        return this.isWcc;
    }

    private boolean isInitializedPerNodeBetweennessCentrality() {
        return this.perNodeBetweenCentrality != null;
    }

    @PublicationReference(author={"Ulrik Brandes"}, title="A Faster Algorithm for Betweenness Centrality", type=PublicationType.Journal, publication="Journal of Mathematical Sociology", year=2001, pages={163, 177})
    public void initializePerNodeBetweennessCentrality() {
        int n = this.numNodes();
        this.perNodeBetweenCentrality = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.perNodeBetweenCentrality.add(0.0);
        }
        ArrayList P = new ArrayList();
        LinkedList<Integer> Q = new LinkedList<Integer>();
        Stack<Integer> S = new Stack<Integer>();
        double[] sigma = new double[n];
        double[] d = new double[n];
        double[] delta = new double[n];
        for (int s = 0; s < n; ++s) {
            S.clear();
            P.clear();
            for (int j = 0; j < n; ++j) {
                P.add(new ArrayList());
                sigma[j] = 0.0;
                d[j] = -1.0;
            }
            sigma[s] = 1.0;
            d[s] = 0.0;
            Q.clear();
            Q.add(s);
            while (!Q.isEmpty()) {
                int v = (Integer)Q.remove();
                S.push(v);
                for (int w : this.neighborIds((NodeNameType)v)) {
                    if (d[w] < 0.0) {
                        Q.add(w);
                        d[w] = d[v] + 1.0;
                    }
                    if (d[w] != d[v] + 1.0) continue;
                    int n2 = w;
                    sigma[n2] = sigma[n2] + sigma[v];
                    ((List)P.get(w)).add(v);
                }
            }
            for (int i = 0; i < n; ++i) {
                delta[i] = 0.0;
            }
            while (!S.isEmpty()) {
                int w = (Integer)S.pop();
                Iterator<Integer> iterator = ((List)P.get(w)).iterator();
                while (iterator.hasNext()) {
                    int v;
                    int n3 = v = iterator.next().intValue();
                    delta[n3] = delta[n3] + sigma[v] / sigma[w] * (1.0 + delta[w]);
                }
                if (w == s) continue;
                this.perNodeBetweenCentrality.plusEquals(w, delta[w]);
            }
        }
        double normalizeBy = 2.0 / (double)((n - 1) * (n - 2));
        for (int i = 0; i < n; ++i) {
            this.perNodeBetweenCentrality.set(i, normalizeBy * this.perNodeBetweenCentrality.get(i));
        }
    }

    public double getPerNodeBetweennessCentralityById(int nodeId) {
        if (!this.isInitializedPerNodeBetweennessCentrality()) {
            this.initializePerNodeBetweennessCentrality();
        }
        return this.perNodeBetweenCentrality.get(nodeId);
    }

    public double getPerNodeBetweennessCentrality(NodeNameType node) {
        if (!this.isInitializedPerNodeBetweennessCentrality()) {
            this.initializePerNodeBetweennessCentrality();
        }
        return this.perNodeBetweenCentrality.get(this.graph.getNodeId(node));
    }
}

