/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.inference;

class Message {
    private static final double MIN_BELIEF = 1.0E-6;
    private final int sourceNode;
    private final double[] values;
    private final double[] tempValues;
    private final double[] logValues;

    public Message(int source, int numLabels) {
        this.sourceNode = source;
        this.values = new double[numLabels];
        this.tempValues = new double[numLabels];
        this.logValues = new double[numLabels];
    }

    public int getSourceNode() {
        return this.sourceNode;
    }

    public void normalizeTempValuesForSumProductAlgorithm() {
        int label;
        double total = 0.0;
        for (label = 0; label < this.tempValues.length; ++label) {
            total += this.tempValues[label];
        }
        label = 0;
        while (label < this.tempValues.length) {
            int n = label++;
            this.tempValues[n] = this.tempValues[n] / total;
        }
    }

    public double update() {
        double delta = 0.0;
        for (int label = 0; label < this.values.length; ++label) {
            delta = Math.max(delta, Math.abs(this.values[label] - this.tempValues[label]));
            this.values[label] = Math.max(this.tempValues[label], 1.0E-6);
            this.logValues[label] = Math.log(this.values[label]);
        }
        return delta;
    }

    public void setTempValue(int label, double value) {
        this.tempValues[label] = value;
    }

    public double getValue(int label) {
        return this.values[label];
    }

    public double getLogValue(int label) {
        return this.logValues[label];
    }

    public void resetToOne() {
        for (int label = 0; label < this.values.length; ++label) {
            this.values[label] = 1.0;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Source ");
        buffer.append(this.sourceNode);
        buffer.append(" [");
        for (double v : this.values) {
            buffer.append(v);
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

