/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.inference;

import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.inference.EnergyFunctionSolver;
import gov.sandia.cognition.graph.inference.NodeNameAwareEnergyFunction;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphWrappingEnergyFunction<LabelType, NodeNameType>
implements NodeNameAwareEnergyFunction<LabelType, NodeNameType> {
    private final DirectedNodeEdgeGraph<NodeNameType> graph;
    private final PotentialHandler<LabelType, NodeNameType> handler;
    private final Map<Integer, LabelType> labeledNodes = new HashMap<Integer, LabelType>();
    private final List<Pair<Integer, Integer>> edges;

    public GraphWrappingEnergyFunction(DirectedNodeEdgeGraph<NodeNameType> graph, PotentialHandler<LabelType, NodeNameType> handler) {
        this.graph = graph;
        this.handler = handler;
        this.edges = new ArrayList<Pair<Integer, Integer>>(graph.getNumEdges());
        for (int i = 0; i < graph.getNumEdges(); ++i) {
            this.edges.add(graph.getEdgeEndpointIds(i));
        }
    }

    @Override
    public Collection<LabelType> getPossibleLabels(int nodeId) {
        return this.handler.getPossibleLabels(this.graph, nodeId);
    }

    @Override
    public Pair<Integer, Integer> getEdge(int i) {
        return this.edges.get(i);
    }

    @Override
    public double getUnaryPotential(int i, LabelType label) {
        return this.handler.getUnaryPotential(this.graph, i, label, this.labeledNodes.get(i));
    }

    @Override
    public double getUnaryCost(int i, LabelType label) {
        double p = this.getUnaryPotential(i, label);
        if (p == 0.0) {
            return Double.MAX_VALUE;
        }
        return -Math.log(p);
    }

    @Override
    public double getPairwisePotential(int edgeId, LabelType ilabel, LabelType jlabel) {
        return this.handler.getPairwisePotential(this.graph, edgeId, ilabel, jlabel);
    }

    @Override
    public double getPairwiseCost(int edgeId, LabelType ilabel, LabelType jlabel) {
        double p = this.getPairwisePotential(edgeId, ilabel, jlabel);
        if (p == 0.0) {
            return Double.MAX_VALUE;
        }
        return -Math.log(p);
    }

    @Override
    public int numEdges() {
        return this.graph.getNumEdges();
    }

    @Override
    public int numNodes() {
        return this.graph.getNumNodes();
    }

    @Override
    public void setLabel(NodeNameType node, LabelType label) {
        int nodeId = this.graph.getNodeId(node);
        if (!this.handler.getPossibleLabels(this.graph, nodeId).contains(label)) {
            throw new IllegalArgumentException("Input label (" + label + ") can't be assigned to node " + node);
        }
        this.labeledNodes.put(nodeId, label);
    }

    public void clearLabels() {
        this.labeledNodes.clear();
    }

    @Override
    public Map<LabelType, Double> getBeliefs(NodeNameType node, EnergyFunctionSolver<LabelType> bp) {
        HashMap<LabelType, Double> ret = new HashMap<LabelType, Double>();
        int nodeId = this.graph.getNodeId(node);
        List<LabelType> labels = this.handler.getPossibleLabels(this.graph, nodeId);
        for (int i = 0; i < labels.size(); ++i) {
            ret.put(labels.get(i), bp.getBelief(nodeId, i));
        }
        return ret;
    }

    public static interface PotentialHandler<LabelType, NodeNameType> {
        public double getPairwisePotential(DirectedNodeEdgeGraph<NodeNameType> var1, int var2, LabelType var3, LabelType var4);

        public double getUnaryPotential(DirectedNodeEdgeGraph<NodeNameType> var1, int var2, LabelType var3, LabelType var4);

        public List<LabelType> getPossibleLabels(DirectedNodeEdgeGraph<NodeNameType> var1, int var2);
    }
}

