/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.DoubleArrayList;
import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.DirectedWeightedNodeEdgeGraph;
import gov.sandia.cognition.util.Pair;
import java.util.HashMap;
import java.util.Map;

@PublicationReference(type=PublicationType.WebPage, author={"Wikipedia"}, title="Sparse matrix - Compressed sparse row (CSR, CRS, or Yale format)", year=2016, url="https://en.wikipedia.org/wiki/Sparse_matrix#Compressed_sparse_row_.28CSR.2C_CRS_or_Yale_format.29")
class YaleFormatWeightedNeighbors<NodeNameType> {
    private final IntArrayList neighborsFirstIdx;
    private final IntArrayList neighbors;
    private final DoubleArrayList wNeighbors;

    public YaleFormatWeightedNeighbors(DirectedNodeEdgeGraph<NodeNameType> graph, boolean removeSelfLoops) {
        int l;
        int i;
        int numNodes = graph.getNumNodes();
        this.neighborsFirstIdx = new IntArrayList(numNodes + 1);
        int neighborsSoFar = 0;
        HashMap edges = new HashMap(graph.getNumNodes());
        for (i = 0; i < graph.getNumNodes(); ++i) {
            edges.put(i, new HashMap());
        }
        for (i = 0; i < graph.getNumEdges(); ++i) {
            Pair<Integer, Integer> edge = graph.getEdgeEndpointIds(i);
            l = (Integer)edge.getFirst();
            int r = (Integer)edge.getSecond();
            if (removeSelfLoops && l == r) continue;
            double w = 1.0;
            if (graph instanceof DirectedWeightedNodeEdgeGraph) {
                w = ((DirectedWeightedNodeEdgeGraph)graph).getEdgeWeight(i);
            }
            if (!((HashMap)edges.get(l)).containsKey(r)) {
                ((HashMap)edges.get(l)).put(r, 0.0);
            }
            ((HashMap)edges.get(l)).put(r, w + (Double)((HashMap)edges.get(l)).get(r));
            if (!((HashMap)edges.get(r)).containsKey(l)) {
                ((HashMap)edges.get(r)).put(l, 0.0);
            }
            ((HashMap)edges.get(r)).put(l, w + (Double)((HashMap)edges.get(r)).get(l));
        }
        for (i = 0; i < graph.getNumNodes(); ++i) {
            this.neighborsFirstIdx.add(neighborsSoFar);
            neighborsSoFar += ((HashMap)edges.get(i)).size();
        }
        this.neighborsFirstIdx.add(neighborsSoFar);
        this.neighbors = new IntArrayList(neighborsSoFar);
        this.wNeighbors = new DoubleArrayList(neighborsSoFar);
        for (i = 0; i < neighborsSoFar; ++i) {
            this.neighbors.add(-1);
            this.wNeighbors.add(0.0);
        }
        for (Map.Entry edgeMap : edges.entrySet()) {
            l = (Integer)edgeMap.getKey();
            for (Map.Entry edge : ((HashMap)edgeMap.getValue()).entrySet()) {
                int r = (Integer)edge.getKey();
                if (removeSelfLoops && l == r) continue;
                double w = (Double)edge.getValue();
                int idx = this.findNextEmptyNeighbor(l);
                this.neighbors.set(idx, r);
                this.wNeighbors.set(idx, w);
            }
        }
    }

    private int findNextEmptyNeighbor(int nodeNum) {
        for (int i = this.neighborsFirstIdx.get(nodeNum); i < this.neighborsFirstIdx.get(nodeNum + 1); ++i) {
            if (this.neighbors.get(i) != -1) continue;
            return i;
        }
        throw new IllegalArgumentException("This node is full, but such shouldn't be possible");
    }

    public IntArrayList getNeighbors() {
        return this.neighbors;
    }

    public IntArrayList getNeighborsFirstIndex() {
        return this.neighborsFirstIdx;
    }

    public DoubleArrayList getNeighborsWeights() {
        return this.wNeighbors;
    }
}

