/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.GraphMetrics;
import gov.sandia.cognition.graph.community.CommunityMetrics;
import gov.sandia.cognition.graph.community.MutableNodePartitioning;
import gov.sandia.cognition.graph.community.NodePartitioning;
import java.util.HashSet;
import java.util.Set;

@PublicationReference(author={"Tanmoy Chakraborty, Sriram Srinivasan, Niloy Ganguly, Animesh Mukherjee, and Sanjukta Bhowmick"}, title="On the permanence of vertices in network communities", year=2014, type=PublicationType.Conference)
public class Permanence<NodeNameType> {
    private final MutableNodePartitioning<NodeNameType> partitions;
    private final DirectedNodeEdgeGraph<NodeNameType> graph;
    private final int maxNumPasses;
    private final double minPermanenceGain;
    private double graphPermanence;

    public Permanence(DirectedNodeEdgeGraph<NodeNameType> graph, int maxNumPasses, double minPermanenceGain) {
        this.partitions = new MutableNodePartitioning<NodeNameType>(graph);
        this.graph = graph;
        this.maxNumPasses = maxNumPasses;
        this.minPermanenceGain = minPermanenceGain;
        this.graphPermanence = -2.0;
    }

    public NodePartitioning<NodeNameType> solveCommunities() {
        int n = this.graph.getNumNodes();
        int iter = 0;
        double sum = 0.0;
        double oldSum = -1.0;
        GraphMetrics<int> metrics = new GraphMetrics<int>(this.graph);
        HashSet<Integer> curNeighborCommunities = new HashSet<Integer>();
        while (Math.abs(sum - oldSum) > this.minPermanenceGain && iter < this.maxNumPasses) {
            ++iter;
            oldSum = sum;
            sum = 0.0;
            IntArrayList order = IntArrayList.range((int)n);
            order.randomizeOrder();
            for (int ii = 0; ii < n; ++ii) {
                int i = order.get(ii);
                if (metrics.degree(i) == 1) continue;
                int curPart = this.partitions.getPartitionById(i);
                double iPerm = CommunityMetrics.computeOneNodePermanenceById(metrics, this.partitions, i, this.graph);
                if (iPerm == 1.0) {
                    sum += iPerm;
                    continue;
                }
                double neighborsCurPerm = 0.0;
                curNeighborCommunities.clear();
                Set<Integer> neighbors = metrics.neighborIds(i);
                for (int neighbor : neighbors) {
                    if (metrics.degree(neighbor) <= 1) continue;
                    neighborsCurPerm += CommunityMetrics.computeOneNodePermanenceById(metrics, this.partitions, neighbor, this.graph);
                    int part = this.partitions.getPartitionById(neighbor);
                    if (part == curPart) continue;
                    curNeighborCommunities.add(part);
                }
                for (int neigComm : curNeighborCommunities) {
                    this.partitions.moveNodeById(i, neigComm);
                    double newPerm = CommunityMetrics.computeOneNodePermanenceById(metrics, this.partitions, i, this.graph);
                    double neighborsNewPerm = 0.0;
                    for (int neighbor : neighbors) {
                        if (metrics.degree(neighbor) <= 1) continue;
                        neighborsNewPerm += CommunityMetrics.computeOneNodePermanenceById(metrics, this.partitions, neighbor, this.graph);
                    }
                    if (iPerm + neighborsCurPerm < newPerm + neighborsNewPerm) {
                        iPerm = newPerm;
                        neighborsCurPerm = neighborsNewPerm;
                        curPart = neigComm;
                        if (iPerm != 1.0) continue;
                        break;
                    }
                    this.partitions.moveNodeById(i, curPart);
                }
                sum += iPerm;
            }
            for (int i = 0; i < n; ++i) {
                if (metrics.degree(i) != 1) continue;
                int neighbor = metrics.neighbors(i).iterator().next();
                int neighborCom = this.partitions.getPartition(neighbor);
                this.partitions.moveNodeById(i, neighborCom);
            }
        }
        this.partitions.removeEmptyPartitions();
        this.graphPermanence = CommunityMetrics.computeGraphPermanance(this.graph, metrics, this.partitions);
        return this.partitions;
    }

    public double permanence() {
        if (this.graphPermanence < -1.0) {
            throw new RuntimeException("Permanence not yet computed");
        }
        return this.graphPermanence;
    }
}

