/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.community.NodePartitioning;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MutableNodePartitioning<NodeNameType>
implements NodePartitioning<NodeNameType> {
    private final IntArrayList nodeToPartitionAssignments;
    private List<Set<Integer>> partitions;
    private final DirectedNodeEdgeGraph<NodeNameType> partitionedGraph;

    MutableNodePartitioning(DirectedNodeEdgeGraph<NodeNameType> graph) {
        this.partitionedGraph = graph;
        int n = graph.getNumNodes();
        this.partitions = new ArrayList<Set<Integer>>(n);
        this.nodeToPartitionAssignments = new IntArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.partitions.add(new HashSet());
            this.partitions.get(i).add(i);
            this.nodeToPartitionAssignments.add(i);
        }
    }

    void removeEmptyPartitions() {
        ArrayList<Set<Integer>> updatedPartitions = new ArrayList<Set<Integer>>();
        int[] partIdMap = new int[this.getNumPartitions()];
        int cnt = 0;
        for (Set<Integer> partition : this.partitions) {
            if (!partition.isEmpty()) {
                partIdMap[cnt] = updatedPartitions.size();
                updatedPartitions.add(partition);
            } else {
                partIdMap[cnt] = -1;
            }
            ++cnt;
        }
        this.partitions = updatedPartitions;
        for (int i = 0; i < this.nodeToPartitionAssignments.size(); ++i) {
            int newPartitionId = partIdMap[this.nodeToPartitionAssignments.get(i)];
            if (newPartitionId == -1) {
                throw new RuntimeException("This should be impossible, but node " + i + "'s old partition assignment was found to be empty");
            }
            this.nodeToPartitionAssignments.set(i, newPartitionId);
        }
    }

    void moveNodeById(int nodeId, int newPartitionId) {
        if (newPartitionId < 0 || newPartitionId >= this.getNumPartitions()) {
            throw new ArrayIndexOutOfBoundsException("Input partition id (" + newPartitionId + ") outside of expected bounds[0, " + this.getNumPartitions() + ")");
        }
        if (nodeId < 0 || nodeId >= this.partitionedGraph.getNumNodes()) {
            throw new ArrayIndexOutOfBoundsException("Input node id (" + nodeId + ") outside of expected bounds[0, " + this.partitionedGraph.getNumNodes() + ")");
        }
        this.partitions.get(this.nodeToPartitionAssignments.get(nodeId)).remove(nodeId);
        this.partitions.get(newPartitionId).add(nodeId);
        this.nodeToPartitionAssignments.set(nodeId, newPartitionId);
    }

    void moveNode(NodeNameType node, int newPartitionId) {
        this.moveNodeById(this.partitionedGraph.getNodeId(node), newPartitionId);
    }

    @Override
    public int getNumPartitions() {
        return this.partitions.size();
    }

    private Set<NodeNameType> translateIds(Set<Integer> ids) {
        HashSet<NodeNameType> ret = new HashSet<NodeNameType>(ids.size());
        for (int id : ids) {
            ret.add(this.partitionedGraph.getNode(id));
        }
        return ret;
    }

    @Override
    public Set<NodeNameType> getPartitionMembers(int i) {
        return this.translateIds(this.partitions.get(i));
    }

    public Set<Integer> getPartitionMemberIds(int i) {
        return this.partitions.get(i);
    }

    @Override
    public Set<NodeNameType> getAllMembers() {
        return new HashSet<NodeNameType>(this.partitionedGraph.getNodes());
    }

    @Override
    public int getPartition(NodeNameType node) {
        return this.nodeToPartitionAssignments.get(this.partitionedGraph.getNodeId(node));
    }

    @Override
    public int getPartitionById(int nodeId) {
        return this.nodeToPartitionAssignments.get(nodeId);
    }

    @Override
    public Double getModularity() {
        return null;
    }
}

