/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph;

import gov.sandia.cognition.collection.DoubleArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.GraphMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class GraphWalker<NodeNameType> {
    private final DirectedNodeEdgeGraph<NodeNameType> graph;
    private final GraphMetrics<NodeNameType> metrics;
    private int curNodeId;
    private int lastNodeId;
    private final NextNodeSelector<NodeNameType> selector;

    public GraphWalker(DirectedNodeEdgeGraph<NodeNameType> graph, NextNodeSelector<NodeNameType> selector) {
        this(graph, selector, new GraphMetrics<NodeNameType>(graph));
    }

    public GraphWalker(DirectedNodeEdgeGraph<NodeNameType> graph, NextNodeSelector<NodeNameType> selector, GraphMetrics<NodeNameType> metrics) {
        this.graph = graph;
        this.metrics = metrics;
        this.selector = selector;
        this.curNodeId = -1;
        this.lastNodeId = -1;
    }

    private int step() {
        int next = this.selector.getNextNode(this.lastNodeId, this.curNodeId, this.metrics);
        this.lastNodeId = this.curNodeId;
        this.curNodeId = next;
        return this.curNodeId;
    }

    public void setStartNode(int nodeId) {
        this.curNodeId = nodeId;
        this.lastNodeId = -1;
    }

    public void setStartNode(NodeNameType node) {
        this.curNodeId = this.graph.getNodeId(node);
        this.lastNodeId = -1;
    }

    public List<NodeNameType> getPath(int numSteps) {
        ArrayList<NodeNameType> path = new ArrayList<NodeNameType>(numSteps);
        for (int i = 0; i < numSteps; ++i) {
            path.add(this.graph.getNode(this.step()));
        }
        return path;
    }

    public List<NodeNameType> getPath(NodeNameType startNode, int numSteps) {
        this.setStartNode(startNode);
        return this.getPath(numSteps);
    }

    public NodeNameType getEndNode(int numSteps) {
        List<NodeNameType> path = this.getPath(numSteps);
        if (path.isEmpty()) {
            return null;
        }
        return path.get(path.size() - 1);
    }

    public NodeNameType getEndNode(NodeNameType startNode, int numSteps) {
        this.setStartNode(startNode);
        return this.getEndNode(numSteps);
    }

    public Map<NodeNameType, Integer> getEndNodes(NodeNameType startNode, int numSteps, int numTries) {
        HashMap<NodeNameType, Integer> endNodes = new HashMap<NodeNameType, Integer>(numTries);
        for (int i = 0; i < numTries; ++i) {
            NodeNameType end = this.getEndNode(startNode, numSteps);
            if (!endNodes.containsKey(end)) {
                endNodes.put(end, 0);
            }
            endNodes.put(end, (Integer)endNodes.get(end) + 1);
        }
        return endNodes;
    }

    public static int probablisticSelect(DoubleArrayList weights, Random r) {
        double sum = 0.0;
        for (int i = 0; i < weights.size(); ++i) {
            sum += weights.get(i);
        }
        double random = r.nextDouble() * sum;
        sum = 0.0;
        for (int i = 0; i < weights.size(); ++i) {
            if (!(random <= (sum += weights.get(i)))) continue;
            return i;
        }
        throw new RuntimeException("It should be impossible that random (" + random + ") is strictly greater than sum (" + sum + ")");
    }

    public static class RandomWalker<NodeNameType>
    implements NextNodeSelector<NodeNameType> {
        private final boolean directed;
        private final Random r;

        public RandomWalker(boolean directed, Random r) {
            this.directed = directed;
            this.r = r;
        }

        @Override
        public int getNextNode(int lastNodeId, int curNodeId, GraphMetrics<NodeNameType> metrics) {
            Set<Integer> possibles = this.directed ? metrics.successorIds(curNodeId) : metrics.neighborIds(curNodeId);
            int numChoices = possibles.size();
            if (numChoices == 0) {
                return curNodeId;
            }
            int which = (int)(this.r.nextDouble() * (double)numChoices);
            if (which == numChoices) {
                --which;
            }
            int cnt = 0;
            for (Integer possible : possibles) {
                if (cnt == which) {
                    return possible;
                }
                ++cnt;
            }
            throw new RuntimeException("After running through " + cnt + " choices, choice " + which + " was never found");
        }
    }

    public static interface NextNodeSelector<NodeNameType> {
        public int getNextNode(int var1, int var2, GraphMetrics<NodeNameType> var3);
    }
}

