/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph;

import gov.sandia.cognition.graph.DenseMemoryGraph;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.DirectedWeightedNodeEdgeGraph;
import gov.sandia.cognition.graph.WeightedDenseMemoryGraph;
import gov.sandia.cognition.util.Pair;

public class GraphUtil {
    public static <NodeType> DirectedNodeEdgeGraph<NodeType> deepCopy(DirectedNodeEdgeGraph<NodeType> src) {
        if (src == null) {
            return null;
        }
        if (src instanceof DirectedWeightedNodeEdgeGraph) {
            return GraphUtil.deepCopy((DirectedWeightedNodeEdgeGraph)src);
        }
        DenseMemoryGraph<NodeType> dst = new DenseMemoryGraph<NodeType>(src.getNumNodes(), src.getNumEdges());
        for (NodeType node : src.getNodes()) {
            dst.addNode(node);
        }
        for (int i = 0; i < src.getNumEdges(); ++i) {
            Pair<Integer, Integer> edge = src.getEdgeEndpointIds(i);
            dst.addEdge(src.getNode((Integer)edge.getFirst()), src.getNode((Integer)edge.getSecond()));
        }
        return dst;
    }

    private static <NodeType> DirectedWeightedNodeEdgeGraph<NodeType> deepCopy(DirectedWeightedNodeEdgeGraph<NodeType> src) {
        WeightedDenseMemoryGraph dst = new WeightedDenseMemoryGraph(src.getNumNodes(), src.getNumEdges());
        for (Object node : src.getNodes()) {
            dst.addNode(node);
        }
        for (int i = 0; i < src.getNumEdges(); ++i) {
            Pair<Integer, Integer> edge = src.getEdgeEndpointIds(i);
            dst.addEdge(src.getNode((Integer)edge.getFirst()), src.getNode((Integer)edge.getSecond()), src.getEdgeWeight(i));
        }
        return dst;
    }
}

