/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph;

import gov.sandia.cognition.collection.DefaultIndexer;
import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.util.DefaultKeyValuePair;
import gov.sandia.cognition.util.Pair;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

public class DenseMemoryGraph<NodeNameType>
implements DirectedNodeEdgeGraph<NodeNameType>,
Serializable {
    private static final long serialVersionUID = 52275907258580715L;
    private static final int MIN_QSORT_SIZE = 5;
    private DefaultIndexer<NodeNameType> nodes;
    private IntArrayList edges;
    private boolean isOptimized;

    public DenseMemoryGraph() {
        this(5, 10);
    }

    public DenseMemoryGraph(int expectedNumNodes, int expectedNumEdges) {
        this.nodes = new DefaultIndexer(expectedNumNodes);
        this.edges = new IntArrayList(expectedNumEdges * 2);
        this.isOptimized = true;
    }

    @Override
    public Collection<NodeNameType> getNodes() {
        return this.nodes.valueList();
    }

    @Override
    public int getNumNodes() {
        return this.nodes.size();
    }

    @Override
    public int getNumEdges() {
        return this.edges.size() / 2;
    }

    @Override
    public void addEdge(NodeNameType left, NodeNameType right) {
        this.newEdge(left, right);
    }

    @Override
    public void addNode(NodeNameType node) {
        this.newNode(node);
    }

    @Override
    public boolean containsNode(NodeNameType node) {
        return this.nodes.hasValue(node);
    }

    @Override
    public Collection<NodeNameType> getSuccessors(NodeNameType node) {
        HashSet<NodeNameType> ret = new HashSet<NodeNameType>();
        int nodeId = this.getNodeId(node);
        int m = this.getNumEdges();
        int idx0 = this.getFirstEdgeFrom(nodeId);
        if (idx0 >= 0 && idx0 <= m) {
            for (int i = idx0; i < m; ++i) {
                Pair<Integer, Integer> endPts = this.getEdgeEndpointIds(i);
                if ((Integer)endPts.getFirst() == nodeId) {
                    ret.add(this.getNode((Integer)endPts.getSecond()));
                    continue;
                }
                if ((Integer)endPts.getFirst() > nodeId) break;
            }
        }
        return ret;
    }

    @Override
    public int getNodeId(NodeNameType node) {
        return this.nodes.getIndex(node);
    }

    @Override
    public NodeNameType getNode(int nodeId) {
        return (NodeNameType)this.nodes.getValue(nodeId);
    }

    @Override
    public Pair<Integer, Integer> getEdgeEndpointIds(int i) {
        this.optimizeEdges();
        return new DefaultKeyValuePair((Object)this.edges.get(2 * i + 0), (Object)this.edges.get(2 * i + 1));
    }

    protected int getFirstEdgeFrom(int nodeVal) {
        int vRep;
        this.optimizeEdges();
        int left = 0;
        int right = this.getNumEdges() - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int midRep = this.edges.get(2 * mid + 0);
            if (midRep < nodeVal) {
                left = mid + 1;
                continue;
            }
            if (midRep > nodeVal) {
                right = mid - 1;
                continue;
            }
            right = mid;
            left = right + 1;
        }
        while (right >= 0 && (vRep = this.edges.get(2 * right + 0)) >= nodeVal) {
            --right;
        }
        return right + 1;
    }

    private int newNode(NodeNameType node) {
        if (this.nodes.hasValue(node)) {
            return this.nodes.getIndex(node);
        }
        int n = this.nodes.add(node);
        return n;
    }

    private synchronized int newEdge(NodeNameType first, NodeNameType second) {
        this.isOptimized = false;
        int firstIdx = this.newNode(first);
        int secondIdx = this.newNode(second);
        int n = this.edges.add(firstIdx) / 2;
        this.edges.add(secondIdx);
        return n;
    }

    protected void optimizeEdges() {
        if (!this.isOptimized) {
            this.runOptimization();
        }
    }

    private synchronized void runOptimization() {
        if (!this.isOptimized) {
            this.quicksortEdges(0, this.getNumEdges() - 1);
            this.isOptimized = true;
        }
    }

    private void quicksortEdges(int firstIdx, int lastIdx) {
        Stack<DefaultKeyValuePair> stack = new Stack<DefaultKeyValuePair>();
        stack.push(new DefaultKeyValuePair((Object)firstIdx, (Object)lastIdx));
        while (!stack.isEmpty()) {
            Pair cur = (Pair)stack.pop();
            int left = (Integer)cur.getFirst();
            int right = (Integer)cur.getSecond();
            if (right - left < 5) {
                this.insertion_sort_edges(left, right);
                continue;
            }
            int randomIdx = (int)(Math.random() * (double)(right - left)) + left;
            this.swap(randomIdx, right);
            int pivotSrc = this.edges.get(2 * right + 0);
            int pivotDst = this.edges.get(2 * right + 1);
            int i = left - 1;
            for (int j = left; j < right; ++j) {
                int edge_jDst;
                int edge_jSrc = this.edges.get(2 * j + 0);
                long c = this.compare(pivotSrc, pivotDst, edge_jSrc, edge_jDst = this.edges.get(2 * j + 1));
                if (c < 0L || ++i == j) continue;
                this.swap(i, j);
            }
            if (++i != right) {
                this.swap(i, right);
            }
            stack.push(new DefaultKeyValuePair((Object)left, (Object)(i - 1)));
            stack.push(new DefaultKeyValuePair((Object)(i + 1), (Object)right));
        }
    }

    private int compare(int src1, int dst1, int src2, int dst2) {
        if (src1 != src2) {
            return Integer.compare(src1, src2);
        }
        return Integer.compare(dst1, dst2);
    }

    private void insertion_sort_edges(int first, int last) {
        for (int i = first; i < last; ++i) {
            int pick = i;
            int valSrc = this.edges.get(pick * 2 + 0);
            int valDst = this.edges.get(pick * 2 + 1);
            for (int j = i + 1; j <= last; ++j) {
                int edgeJDst;
                int edgeJSrc = this.edges.get(j * 2 + 0);
                if (this.compare(valSrc, valDst, edgeJSrc, edgeJDst = this.edges.get(j * 2 + 1)) <= 0) continue;
                pick = j;
                valSrc = edgeJSrc;
                valDst = edgeJDst;
            }
            if (pick == i) continue;
            this.swap(i, pick);
        }
    }

    protected void swap(int i, int j) {
        this.edges.swap(2 * i, 2 * j);
        this.edges.swap(2 * i + 1, 2 * j + 1);
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.isOptimized = true;
    }

    public static void serialize(String fileName, DenseMemoryGraph<?> graph) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(fileName));){
            out.writeObject(graph);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static DenseMemoryGraph<?> deserialize(String fileName) {
        DenseMemoryGraph graph = null;
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));){
            graph = (DenseMemoryGraph)in.readObject();
        }
        catch (IOException | ClassNotFoundException ioe) {
            throw new RuntimeException(ioe);
        }
        return graph;
    }
}

