/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.framework.Cogxel;
import gov.sandia.cognition.framework.CogxelFactory;
import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.DefaultCogxelFactory;
import gov.sandia.cognition.framework.SemanticIdentifier;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.SemanticLabel;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.util.ObjectUtil;

public class CogxelDoubleConverter
implements CogxelConverter<Double> {
    private SemanticLabel label;
    private SemanticIdentifier identifier;
    private SemanticIdentifierMap semanticIdentifierMap;
    private CogxelFactory cogxelFactory;

    public CogxelDoubleConverter() {
        this(null, null);
    }

    public CogxelDoubleConverter(SemanticLabel label) {
        this(label, null);
    }

    public CogxelDoubleConverter(SemanticLabel label, SemanticIdentifierMap semanticIdentifierMap) {
        this(label, semanticIdentifierMap, (CogxelFactory)DefaultCogxelFactory.INSTANCE);
    }

    public CogxelDoubleConverter(SemanticLabel label, SemanticIdentifierMap semanticIdentifierMap, CogxelFactory cogxelFactory) {
        this.setLabel(label);
        this.setSemanticIdentifierMap(semanticIdentifierMap);
        this.setCogxelFactory(cogxelFactory);
    }

    public CogxelDoubleConverter(CogxelDoubleConverter other) {
        this(other.getLabel(), other.getSemanticIdentifierMap(), other.getCogxelFactory());
    }

    public CogxelDoubleConverter clone() {
        return new CogxelDoubleConverter(this);
    }

    public boolean equals(Object other) {
        if (other instanceof CogxelDoubleConverter) {
            return this.equals((CogxelDoubleConverter)other);
        }
        return false;
    }

    public boolean equals(CogxelDoubleConverter other) {
        return other != null && ObjectUtil.equalsSafe((Object)this.getLabel(), (Object)other.getLabel());
    }

    public int hashCode() {
        return ObjectUtil.hashCodeSafe((Object)this.label);
    }

    protected void buildIdentifierCache() {
        this.setIdentifier(null);
        SemanticIdentifierMap identifierMap = this.getSemanticIdentifierMap();
        if (identifierMap != null && this.getLabel() != null) {
            this.setIdentifier(identifierMap.addLabel(this.getLabel()));
        } else {
            this.setIdentifier(null);
        }
    }

    @Override
    public Double fromCogxels(CogxelState cogxels) {
        if (cogxels == null) {
            throw new IllegalArgumentException("cogxels is null");
        }
        if (this.getSemanticIdentifierMap() == null) {
            throw new IllegalStateException("The semanticIdentifierMap is not set.");
        }
        if (this.getIdentifier() == null) {
            throw new IllegalStateException("The semantic identifier is null");
        }
        return cogxels.getCogxelActivation(this.getIdentifier());
    }

    @Override
    public void toCogxels(Double data, CogxelState cogxels) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (cogxels == null) {
            throw new IllegalArgumentException("cogxels is null");
        }
        if (this.getSemanticIdentifierMap() == null) {
            throw new IllegalStateException("The semanticIdentifierMap is not set.");
        }
        if (this.getIdentifier() == null) {
            throw new IllegalStateException("The semantic identifier is null");
        }
        Cogxel cogxel = cogxels.getOrCreateCogxel(this.getIdentifier(), this.getCogxelFactory());
        cogxel.setActivation(data.doubleValue());
    }

    @Override
    public SemanticIdentifierMap getSemanticIdentifierMap() {
        return this.semanticIdentifierMap;
    }

    @Override
    public void setSemanticIdentifierMap(SemanticIdentifierMap semanticIdentifierMap) {
        this.semanticIdentifierMap = semanticIdentifierMap;
        this.buildIdentifierCache();
    }

    public SemanticLabel getLabel() {
        return this.label;
    }

    public void setLabel(SemanticLabel label) {
        this.label = label;
    }

    protected SemanticIdentifier getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(SemanticIdentifier identifier) {
        this.identifier = identifier;
    }

    public CogxelFactory getCogxelFactory() {
        return this.cogxelFactory;
    }

    public void setCogxelFactory(CogxelFactory cogxelFactory) {
        this.cogxelFactory = cogxelFactory;
    }
}

