/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.framework.learning.converter.CogxelVectorConverter;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CogxelVectorCollectionConverter
implements CogxelConverter<Collection<Vector>> {
    private Collection<CogxelVectorConverter> cogxelVectorConverters;

    public CogxelVectorCollectionConverter(Collection<CogxelVectorConverter> cogxelVectorConverters) {
        this.setCogxelVectorConverters(cogxelVectorConverters);
    }

    public CogxelVectorCollectionConverter(CogxelVectorConverter ... vectorConverters) {
        ArrayList<CogxelVectorConverter> c = new ArrayList<CogxelVectorConverter>(vectorConverters.length);
        for (CogxelVectorConverter v : vectorConverters) {
            c.add(v);
        }
        this.setCogxelVectorConverters(c);
    }

    public CogxelVectorCollectionConverter(CogxelVectorCollectionConverter other) {
        this(other.getCogxelVectorConverters());
    }

    public CogxelVectorCollectionConverter clone() {
        return new CogxelVectorCollectionConverter(this);
    }

    @Override
    public ArrayList<Vector> fromCogxels(CogxelState cogxels) {
        ArrayList<Vector> retval = new ArrayList<Vector>(this.getNumVectors());
        for (CogxelVectorConverter c : this.getCogxelVectorConverters()) {
            retval.add(c.fromCogxels(cogxels));
        }
        return retval;
    }

    @Override
    public void toCogxels(Collection<Vector> data, CogxelState cogxels) {
        Iterator<CogxelVectorConverter> cvc = this.getCogxelVectorConverters().iterator();
        for (Vector v : data) {
            cvc.next().toCogxels(v, cogxels);
        }
    }

    @Override
    public SemanticIdentifierMap getSemanticIdentifierMap() {
        return this.getCogxelVectorConverters().iterator().next().getSemanticIdentifierMap();
    }

    @Override
    public void setSemanticIdentifierMap(SemanticIdentifierMap semanticIdentifierMap) {
        for (CogxelVectorConverter cvc : this.getCogxelVectorConverters()) {
            cvc.setSemanticIdentifierMap(semanticIdentifierMap);
        }
    }

    public int getNumVectors() {
        return this.getCogxelVectorConverters().size();
    }

    public Collection<CogxelVectorConverter> getCogxelVectorConverters() {
        return this.cogxelVectorConverters;
    }

    protected void setCogxelVectorConverters(Collection<CogxelVectorConverter> cogxelVectorConverters) {
        this.cogxelVectorConverters = cogxelVectorConverters;
    }
}

