/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.framework.Cogxel;
import gov.sandia.cognition.framework.CogxelFactory;
import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.DefaultCogxelFactory;
import gov.sandia.cognition.framework.SemanticIdentifier;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.SemanticLabel;
import gov.sandia.cognition.framework.learning.converter.AbstractCogxelConverter;
import gov.sandia.cognition.util.ObjectUtil;

public class CogxelBooleanConverter
extends AbstractCogxelConverter<Boolean> {
    private SemanticLabel label;
    private SemanticIdentifier identifier;
    private CogxelFactory cogxelFactory;

    public CogxelBooleanConverter() {
        this((SemanticLabel)null);
    }

    public CogxelBooleanConverter(SemanticLabel label) {
        this(label, null);
    }

    public CogxelBooleanConverter(SemanticLabel label, SemanticIdentifierMap semanticIdentifierMap) {
        this(label, semanticIdentifierMap, (CogxelFactory)DefaultCogxelFactory.INSTANCE);
    }

    public CogxelBooleanConverter(SemanticLabel label, SemanticIdentifierMap semanticIdentifierMap, CogxelFactory cogxelFactory) {
        super(semanticIdentifierMap);
        this.setLabel(label);
        this.setCogxelFactory(cogxelFactory);
    }

    @Override
    public CogxelBooleanConverter clone() {
        return (CogxelBooleanConverter)super.clone();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof CogxelBooleanConverter && this.equals((CogxelBooleanConverter)other);
    }

    public int hashCode() {
        return ObjectUtil.hashCodeSafe((Object)this.label);
    }

    public boolean equals(CogxelBooleanConverter other) {
        return other != null && ObjectUtil.equalsSafe((Object)this.getLabel(), (Object)other.getLabel());
    }

    @Override
    protected void buildIdentifierCache() {
        this.setIdentifier(null);
        SemanticIdentifierMap identifierMap = this.getSemanticIdentifierMap();
        if (identifierMap != null && this.getLabel() != null) {
            this.setIdentifier(identifierMap.addLabel(this.getLabel()));
        } else {
            this.setIdentifier(null);
        }
    }

    @Override
    public Boolean fromCogxels(CogxelState cogxels) {
        if (cogxels == null) {
            throw new IllegalArgumentException("cogxels is null");
        }
        if (this.getSemanticIdentifierMap() == null) {
            throw new IllegalStateException("The semanticIdentifierMap is not set.");
        }
        if (this.getIdentifier() == null) {
            throw new IllegalStateException("The semantic identifier is null");
        }
        return cogxels.getCogxelActivation(this.getIdentifier()) > 0.0;
    }

    @Override
    public void toCogxels(Boolean data, CogxelState cogxels) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (cogxels == null) {
            throw new IllegalArgumentException("cogxels is null");
        }
        if (this.getSemanticIdentifierMap() == null) {
            throw new IllegalStateException("The semanticIdentifierMap is not set.");
        }
        if (this.getIdentifier() == null) {
            throw new IllegalStateException("The semantic identifier is null");
        }
        Cogxel cogxel = cogxels.getOrCreateCogxel(this.getIdentifier(), this.getCogxelFactory());
        cogxel.setActivation(data != false ? 1.0 : -1.0);
    }

    public SemanticLabel getLabel() {
        return this.label;
    }

    public void setLabel(SemanticLabel label) {
        this.label = label;
    }

    protected SemanticIdentifier getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(SemanticIdentifier identifier) {
        this.identifier = identifier;
    }

    public CogxelFactory getCogxelFactory() {
        return this.cogxelFactory;
    }

    public void setCogxelFactory(CogxelFactory cogxelFactory) {
        this.cogxelFactory = cogxelFactory;
    }
}

