/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.SemanticLabel;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.framework.learning.converter.CogxelVectorConverter;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.ArrayList;
import java.util.Collection;

public class CogxelMatrixConverter
implements CogxelConverter<Matrix> {
    private ArrayList<CogxelVectorConverter> columnConverters;
    private SemanticIdentifierMap semanticIdentifierMap;

    public CogxelMatrixConverter(Collection<? extends Iterable<SemanticLabel>> columns) {
        ArrayList<CogxelVectorConverter> localColumnConverters = new ArrayList<CogxelVectorConverter>(columns.size());
        for (Iterable<SemanticLabel> iterable : columns) {
            localColumnConverters.add(new CogxelVectorConverter(iterable));
        }
        this.setColumnConverters(localColumnConverters);
        this.setSemanticIdentifierMap(null);
    }

    public CogxelMatrixConverter(ArrayList<CogxelVectorConverter> columnConverters) {
        this(columnConverters, null);
    }

    public CogxelMatrixConverter(ArrayList<CogxelVectorConverter> columnConverters, SemanticIdentifierMap semanticIdentifierMap) {
        this.setColumnConverters(columnConverters);
        this.setSemanticIdentifierMap(semanticIdentifierMap);
    }

    public CogxelMatrixConverter(CogxelMatrixConverter other) {
        this((ArrayList)other.getColumnConverters().clone(), other.getSemanticIdentifierMap());
    }

    public CogxelMatrixConverter clone() {
        return new CogxelMatrixConverter(this);
    }

    @Override
    public SemanticIdentifierMap getSemanticIdentifierMap() {
        return this.semanticIdentifierMap;
    }

    @Override
    public void setSemanticIdentifierMap(SemanticIdentifierMap semanticIdentifierMap) {
        this.semanticIdentifierMap = semanticIdentifierMap;
        for (CogxelVectorConverter column : this.getColumnConverters()) {
            column.setSemanticIdentifierMap(semanticIdentifierMap);
        }
    }

    @Override
    public Matrix fromCogxels(CogxelState cogxels) {
        Matrix retval = null;
        int N = this.getColumnConverters().size();
        for (int j = 0; j < N; ++j) {
            Vector column = this.getColumnConverters().get(j).fromCogxels(cogxels);
            if (retval == null) {
                int M = column.getDimensionality();
                retval = MatrixFactory.getDefault().createMatrix(M, N);
            }
            retval.setColumn(j, column);
        }
        return retval;
    }

    @Override
    public void toCogxels(Matrix data, CogxelState cogxels) {
        for (int j = 0; j < this.getColumnConverters().size(); ++j) {
            Vector column = data.getColumn(j);
            this.getColumnConverters().get(j).toCogxels(column, cogxels);
        }
    }

    public ArrayList<CogxelVectorConverter> getColumnConverters() {
        return this.columnConverters;
    }

    protected void setColumnConverters(ArrayList<CogxelVectorConverter> columnConverters) {
        if (columnConverters == null) {
            throw new NullPointerException("columnConverters cannot be null!");
        }
        this.columnConverters = columnConverters;
    }
}

