/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.framework.CognitiveModel;
import gov.sandia.cognition.framework.CognitiveModelState;
import gov.sandia.cognition.framework.CognitiveModuleState;
import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.concurrent.AbstractConcurrentCognitiveModule;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModuleSettings;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;

public class EvaluatorBasedCognitiveModule<InputType, OutputType>
extends AbstractConcurrentCognitiveModule {
    private String name;
    private EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings;
    protected InputType input;
    protected OutputType output;
    public static final String DEFAULT_NAME = "Evaluator-based Cognitive Module";

    public EvaluatorBasedCognitiveModule(CognitiveModel model, EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings, String name) {
        this.setSettings((EvaluatorBasedCognitiveModuleSettings<InputType, OutputType>)settings.clone());
        this.getInputConverter().setSemanticIdentifierMap(model.getSemanticIdentifierMap());
        this.getOutputConverter().setSemanticIdentifierMap(model.getSemanticIdentifierMap());
        this.setName(name);
    }

    public CognitiveModuleState initializeState(CognitiveModelState modelState) {
        return null;
    }

    public void readState(CognitiveModelState modelState, CognitiveModuleState previousModuleState) {
        CogxelState cogxels = modelState.getCogxels();
        this.input = this.getInputConverter().fromCogxels(cogxels);
    }

    public void evaluate() {
        this.output = this.getEvaluator().evaluate(this.input);
        this.input = null;
    }

    public CognitiveModuleState writeState(CognitiveModelState modelState) {
        CogxelState cogxels = modelState.getCogxels();
        this.getOutputConverter().toCogxels(this.output, cogxels);
        this.output = null;
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> getSettings() {
        return this.settings;
    }

    protected void setSettings(EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings) {
        this.settings = settings;
    }

    public Evaluator<? super InputType, ? extends OutputType> getEvaluator() {
        return this.getSettings().getEvaluator();
    }

    public CogxelConverter<InputType> getInputConverter() {
        return this.getSettings().getInputConverter();
    }

    public CogxelConverter<OutputType> getOutputConverter() {
        return this.getSettings().getOutputConverter();
    }
}

