/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.framework.learning.converter.CogxelInputOutputPairConverter;
import gov.sandia.cognition.learning.data.DefaultWeightedInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.WeightedInputOutputPair;
import gov.sandia.cognition.util.Pair;

public class CogxelWeightedInputOutputPairConverter<InputType, OutputType>
implements CogxelConverter<WeightedInputOutputPair<InputType, OutputType>> {
    private CogxelInputOutputPairConverter<InputType, OutputType> pairConverter;
    private CogxelConverter<Double> weightConverter;

    public CogxelWeightedInputOutputPairConverter() {
        this(null, null, null);
    }

    public CogxelWeightedInputOutputPairConverter(CogxelConverter<InputType> inputConverter, CogxelConverter<OutputType> outputConverter, CogxelConverter<Double> weightConverter) {
        this.setPairConverter(new CogxelInputOutputPairConverter<InputType, OutputType>(inputConverter, outputConverter));
        this.setWeightConverter(weightConverter);
    }

    public CogxelWeightedInputOutputPairConverter(CogxelWeightedInputOutputPairConverter other) {
        this(other.getPairConverter().getInputConverter().clone(), other.getPairConverter().getOutputConverter().clone(), other.getWeightConverter().clone());
    }

    public CogxelWeightedInputOutputPairConverter<InputType, OutputType> clone() {
        return new CogxelWeightedInputOutputPairConverter<InputType, OutputType>(this);
    }

    public CogxelConverter<Double> getWeightConverter() {
        return this.weightConverter;
    }

    public void setWeightConverter(CogxelConverter<Double> weightConverter) {
        this.weightConverter = weightConverter;
    }

    @Override
    public WeightedInputOutputPair<InputType, OutputType> fromCogxels(CogxelState cogxels) {
        InputOutputPair pair = (InputOutputPair)this.getPairConverter().fromCogxels(cogxels);
        double weight = this.getWeightConverter().fromCogxels(cogxels);
        return new DefaultWeightedInputOutputPair((Pair)pair, weight);
    }

    @Override
    public void toCogxels(WeightedInputOutputPair<InputType, OutputType> data, CogxelState cogxels) {
        this.getPairConverter().toCogxels(data, cogxels);
        this.getWeightConverter().toCogxels(data.getWeight(), cogxels);
    }

    public CogxelInputOutputPairConverter<InputType, OutputType> getPairConverter() {
        return this.pairConverter;
    }

    public void setPairConverter(CogxelInputOutputPairConverter<InputType, OutputType> pairConverter) {
        this.pairConverter = pairConverter;
    }

    @Override
    public SemanticIdentifierMap getSemanticIdentifierMap() {
        return this.getPairConverter().getSemanticIdentifierMap();
    }

    @Override
    public void setSemanticIdentifierMap(SemanticIdentifierMap semanticIdentifierMap) {
        this.getPairConverter().setSemanticIdentifierMap(semanticIdentifierMap);
        this.getWeightConverter().setSemanticIdentifierMap(semanticIdentifierMap);
    }
}

