/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.framework.Cogxel;
import gov.sandia.cognition.framework.CogxelFactory;
import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.DefaultCogxelFactory;
import gov.sandia.cognition.framework.SemanticIdentifier;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.SemanticLabel;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.math.matrix.DefaultVectorFactoryContainer;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class CogxelVectorConverter
extends DefaultVectorFactoryContainer
implements CogxelConverter<Vector> {
    private ArrayList<SemanticLabel> labels;
    private SemanticIdentifierMap semanticIdentifierMap;
    private ArrayList<SemanticIdentifier> identifiers;
    private HashMap<SemanticIdentifier, Integer> identifierToIndexMap;
    private CogxelFactory cogxelFactory;

    public CogxelVectorConverter() {
        this.setLabels(new ArrayList<SemanticLabel>());
        this.setSemanticIdentifierMap(null);
        this.setIdentifiers(new ArrayList<SemanticIdentifier>());
        this.setIdentifierToIndexMap(new HashMap<SemanticIdentifier, Integer>());
        this.setVectorFactory(VectorFactory.getDefault());
        this.setCogxelFactory((CogxelFactory)DefaultCogxelFactory.INSTANCE);
    }

    public CogxelVectorConverter(SemanticLabel ... labels) {
        this(labels, (SemanticIdentifierMap)null);
    }

    public CogxelVectorConverter(Iterable<SemanticLabel> labels) {
        this(labels, null);
    }

    public CogxelVectorConverter(SemanticLabel[] labels, SemanticIdentifierMap semanticIdentifierMap) {
        this(Arrays.asList(labels), semanticIdentifierMap);
    }

    public CogxelVectorConverter(Iterable<SemanticLabel> labels, SemanticIdentifierMap semanticIdentifierMap) {
        this();
        this.addLabels(labels);
        this.setSemanticIdentifierMap(semanticIdentifierMap);
    }

    public CogxelVectorConverter(SemanticLabel[] labels, SemanticIdentifierMap semanticIdentifierMap, VectorFactory<?> vectorFactory, CogxelFactory cogxelFactory) {
        this(Arrays.asList(labels), semanticIdentifierMap, vectorFactory, cogxelFactory);
    }

    public CogxelVectorConverter(Iterable<SemanticLabel> labels, SemanticIdentifierMap semanticIdentifierMap, VectorFactory<?> vectorFactory, CogxelFactory cogxelFactory) {
        this(labels, semanticIdentifierMap);
        this.setVectorFactory(vectorFactory);
        this.setCogxelFactory(cogxelFactory);
    }

    public CogxelVectorConverter(CogxelVectorConverter other) {
        this(new ArrayList<SemanticLabel>(other.getLabels()), other.getSemanticIdentifierMap(), other.getVectorFactory(), other.getCogxelFactory());
    }

    public CogxelVectorConverter clone() {
        return new CogxelVectorConverter(this);
    }

    public void addLabel(SemanticLabel label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.getLabels().add(label);
        this.addLabelToIdentifierCache(label);
    }

    public void addLabels(Iterable<SemanticLabel> labels) {
        for (SemanticLabel label : labels) {
            this.addLabel(label);
        }
    }

    public void addLabels(SemanticLabel[] labels) {
        for (SemanticLabel label : labels) {
            this.addLabel(label);
        }
    }

    protected void buildIdentifierCache() {
        this.setIdentifiers(new ArrayList<SemanticIdentifier>());
        this.setIdentifierToIndexMap(new HashMap<SemanticIdentifier, Integer>());
        SemanticIdentifierMap identifierMap = this.getSemanticIdentifierMap();
        if (identifierMap != null) {
            for (SemanticLabel label : this.getLabels()) {
                this.addLabelToIdentifierCache(label);
            }
        }
    }

    protected void addLabelToIdentifierCache(SemanticLabel label) {
        if (this.semanticIdentifierMap == null) {
            return;
        }
        SemanticIdentifier identifier = this.getSemanticIdentifierMap().addLabel(label);
        int index = this.getIdentifiers().size();
        this.getIdentifiers().add(identifier);
        this.getIdentifierToIndexMap().put(identifier, index);
    }

    @Override
    public Vector fromCogxels(CogxelState cogxels) {
        if (cogxels == null) {
            throw new IllegalArgumentException("cogxels is null");
        }
        if (this.getSemanticIdentifierMap() == null) {
            throw new IllegalStateException("The semanticIdentifierMap is not set.");
        }
        Vector vector = this.createEmptyVector();
        if (cogxels.getNumCogxels() > this.getDimensionality()) {
            int index = 0;
            for (SemanticIdentifier identifier : this.getIdentifiers()) {
                double value = cogxels.getCogxelActivation(identifier);
                vector.setElement(index, value);
                ++index;
            }
        } else {
            for (Cogxel cogxel : cogxels) {
                SemanticIdentifier identifier = cogxel.getSemanticIdentifier();
                int index = this.findIndexForIdentifier(identifier);
                if (index < 0) continue;
                double value = cogxel.getActivation();
                vector.setElement(index, value);
            }
        }
        return vector;
    }

    @Override
    public void toCogxels(Vector data, CogxelState cogxels) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (cogxels == null) {
            throw new IllegalArgumentException("cogxels is null");
        }
        if (this.getSemanticIdentifierMap() == null) {
            throw new IllegalStateException("The semanticIdentifierMap is not set.");
        }
        int dimensionality = data.getDimensionality();
        if (dimensionality != this.getDimensionality()) {
            throw new DimensionalityMismatchException(dimensionality, this.getDimensionality());
        }
        CogxelFactory factory = this.getCogxelFactory();
        for (int i = 0; i < dimensionality; ++i) {
            double value = data.getElement(i);
            SemanticIdentifier identifier = this.getIdentifiers().get(i);
            Cogxel cogxel = cogxels.getOrCreateCogxel(identifier, factory);
            cogxel.setActivation(value);
        }
    }

    protected int findIndexForIdentifier(SemanticIdentifier identifier) {
        Integer index = this.getIdentifierToIndexMap().get(identifier);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public boolean equals(Object other) {
        if (other instanceof CogxelVectorConverter) {
            return this.equals((CogxelVectorConverter)other);
        }
        return false;
    }

    public boolean equals(CogxelVectorConverter other) {
        if (other == null || other.getDimensionality() != this.getDimensionality()) {
            return false;
        }
        int length = this.getDimensionality();
        for (int i = 0; i < length; ++i) {
            if (this.getLabels().get(i).equals(other.getLabels().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        if (!CollectionUtil.isEmpty(this.labels)) {
            for (SemanticLabel label : this.labels) {
                hash = 43 * hash + ObjectUtil.hashCodeSafe((Object)label);
            }
        }
        return hash;
    }

    public Vector createEmptyVector() {
        return this.getVectorFactory().createVector(this.getDimensionality());
    }

    public int getDimensionality() {
        return this.getLabels().size();
    }

    @Override
    public SemanticIdentifierMap getSemanticIdentifierMap() {
        return this.semanticIdentifierMap;
    }

    @Override
    public void setSemanticIdentifierMap(SemanticIdentifierMap semanticIdentifierMap) {
        this.semanticIdentifierMap = semanticIdentifierMap;
        this.buildIdentifierCache();
    }

    public ArrayList<SemanticLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(ArrayList<SemanticLabel> labels) {
        this.labels = labels;
        this.buildIdentifierCache();
    }

    protected ArrayList<SemanticIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    protected void setIdentifiers(ArrayList<SemanticIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    protected HashMap<SemanticIdentifier, Integer> getIdentifierToIndexMap() {
        return this.identifierToIndexMap;
    }

    protected void setIdentifierToIndexMap(HashMap<SemanticIdentifier, Integer> identifierToIndexMap) {
        this.identifierToIndexMap = identifierToIndexMap;
    }

    public CogxelFactory getCogxelFactory() {
        return this.cogxelFactory;
    }

    public void setCogxelFactory(CogxelFactory cogxelFactory) {
        this.cogxelFactory = cogxelFactory;
    }
}

