/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning.converter;

import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.SemanticIdentifierMap;
import gov.sandia.cognition.framework.learning.converter.AbstractCogxelConverter;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;

public abstract class AbstractCogxelPairConverter<FirstType, SecondType, PairType extends Pair<FirstType, SecondType>>
extends AbstractCogxelConverter<PairType> {
    private CogxelConverter<FirstType> firstConverter;
    private CogxelConverter<SecondType> secondConverter;

    public AbstractCogxelPairConverter() {
        this(null, null);
    }

    public AbstractCogxelPairConverter(CogxelConverter<FirstType> firstConverter, CogxelConverter<SecondType> secondConverter) {
        this(firstConverter, secondConverter, null);
    }

    public AbstractCogxelPairConverter(CogxelConverter<FirstType> firstConverter, CogxelConverter<SecondType> secondConverter, SemanticIdentifierMap semanticIdentifierMap) {
        this.setFirstConverter(firstConverter);
        this.setSecondConverter(secondConverter);
        this.setSemanticIdentifierMap(semanticIdentifierMap);
    }

    @Override
    public AbstractCogxelPairConverter<FirstType, SecondType, PairType> clone() {
        AbstractCogxelPairConverter clone = (AbstractCogxelPairConverter)super.clone();
        clone.firstConverter = (CogxelConverter)ObjectUtil.cloneSafe(this.firstConverter);
        clone.secondConverter = (CogxelConverter)ObjectUtil.cloneSafe(this.secondConverter);
        return clone;
    }

    public boolean equals(Object other) {
        return other instanceof AbstractCogxelPairConverter && this.equals((AbstractCogxelPairConverter)other);
    }

    protected boolean equals(AbstractCogxelPairConverter<?, ?, ?> other) {
        return other != null && ObjectUtil.equalsSafe(this.getFirstConverter(), other.getFirstConverter()) && ObjectUtil.equalsSafe(this.getSecondConverter(), other.getSecondConverter());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + ObjectUtil.hashCodeSafe(this.firstConverter);
        hash = 89 * hash + ObjectUtil.hashCodeSafe(this.secondConverter);
        return hash;
    }

    public abstract PairType createPair(FirstType var1, SecondType var2);

    @Override
    public PairType fromCogxels(CogxelState cogxels) {
        FirstType first = this.getFirstConverter().fromCogxels(cogxels);
        SecondType second = this.getSecondConverter().fromCogxels(cogxels);
        return this.createPair(first, second);
    }

    @Override
    public void toCogxels(PairType data, CogxelState cogxels) {
        this.getFirstConverter().toCogxels(data.getFirst(), cogxels);
        this.getSecondConverter().toCogxels(data.getSecond(), cogxels);
    }

    @Override
    public void setSemanticIdentifierMap(SemanticIdentifierMap semanticIdentifierMap) {
        super.setSemanticIdentifierMap(semanticIdentifierMap);
        if (this.getFirstConverter() != null) {
            this.getFirstConverter().setSemanticIdentifierMap(semanticIdentifierMap);
        }
        if (this.getSecondConverter() != null) {
            this.getSecondConverter().setSemanticIdentifierMap(semanticIdentifierMap);
        }
    }

    public CogxelConverter<FirstType> getFirstConverter() {
        return this.firstConverter;
    }

    public void setFirstConverter(CogxelConverter<FirstType> firstConverter) {
        this.firstConverter = firstConverter;
        if (this.firstConverter != null) {
            this.firstConverter.setSemanticIdentifierMap(this.getSemanticIdentifierMap());
        }
    }

    public CogxelConverter<SecondType> getSecondConverter() {
        return this.secondConverter;
    }

    public void setSecondConverter(CogxelConverter<SecondType> secondConverter) {
        this.secondConverter = secondConverter;
        if (this.secondConverter != null) {
            this.secondConverter.setSemanticIdentifierMap(this.getSemanticIdentifierMap());
        }
    }
}

