/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning;

import gov.sandia.cognition.evaluator.StatefulEvaluator;
import gov.sandia.cognition.framework.CognitiveModel;
import gov.sandia.cognition.framework.CognitiveModule;
import gov.sandia.cognition.framework.CognitiveModuleFactory;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModule;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModuleSettings;
import gov.sandia.cognition.framework.learning.StatefulEvaluatorBasedCognitiveModule;
import gov.sandia.cognition.util.CloneableSerializable;

public class EvaluatorBasedCognitiveModuleFactory<InputType, OutputType>
implements CognitiveModuleFactory,
CloneableSerializable {
    private EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings;
    private String name;

    public EvaluatorBasedCognitiveModuleFactory() {
        this(new EvaluatorBasedCognitiveModuleSettings(), "Evaluator-based Cognitive Module");
    }

    public EvaluatorBasedCognitiveModuleFactory(EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings, String name) {
        this.setSettings(settings);
        this.setName(name);
    }

    public EvaluatorBasedCognitiveModuleFactory(EvaluatorBasedCognitiveModuleFactory<InputType, OutputType> other) {
        this((EvaluatorBasedCognitiveModuleSettings<InputType, OutputType>)other.getSettings().clone(), other.getName());
    }

    public EvaluatorBasedCognitiveModuleFactory<InputType, OutputType> clone() {
        return new EvaluatorBasedCognitiveModuleFactory<InputType, OutputType>(this);
    }

    public CognitiveModule createModule(CognitiveModel model) {
        EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> localSettings = this.getSettings();
        if (localSettings == null) {
            throw new IllegalStateException("settings is null");
        }
        if (localSettings.getEvaluator() == null) {
            throw new IllegalStateException("settings evaluator is null");
        }
        if (localSettings.getEvaluator() instanceof StatefulEvaluator) {
            return new StatefulEvaluatorBasedCognitiveModule<InputType, OutputType>(model, this.getSettings(), this.getName());
        }
        return new EvaluatorBasedCognitiveModule<InputType, OutputType>(model, this.getSettings(), this.getName());
    }

    public EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> getSettings() {
        return this.settings;
    }

    public void setSettings(EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings) {
        this.settings = settings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

