/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning;

import gov.sandia.cognition.evaluator.StatefulEvaluator;
import gov.sandia.cognition.framework.CognitiveModel;
import gov.sandia.cognition.framework.CognitiveModelState;
import gov.sandia.cognition.framework.CognitiveModuleState;
import gov.sandia.cognition.framework.CogxelState;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModule;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModuleSettings;
import gov.sandia.cognition.framework.lite.CognitiveModuleStateWrapper;
import gov.sandia.cognition.util.CloneableSerializable;

public class StatefulEvaluatorBasedCognitiveModule<InputType, OutputType>
extends EvaluatorBasedCognitiveModule<InputType, OutputType> {
    private CognitiveModuleStateWrapper stateWrapper;

    public StatefulEvaluatorBasedCognitiveModule(CognitiveModel model, EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> settings, String name) {
        super(model, settings, name);
        if (!(settings.getEvaluator() instanceof StatefulEvaluator)) {
            throw new IllegalArgumentException("The given Evaluator is not a StatefulEvaluator.");
        }
    }

    @Override
    public CognitiveModuleState initializeState(CognitiveModelState modelState) {
        return new CognitiveModuleStateWrapper(this.getStatefulEvaluator().createDefaultState());
    }

    @Override
    public void readState(CognitiveModelState modelState, CognitiveModuleState previousModuleState) {
        if (previousModuleState == null) {
            throw new IllegalArgumentException("previousModuleState cannot be null");
        }
        if (!(previousModuleState instanceof CognitiveModuleStateWrapper)) {
            throw new IllegalArgumentException("previousModuleState is not of type CognitiveModuleStateWrapper");
        }
        this.stateWrapper = (CognitiveModuleStateWrapper)previousModuleState;
        StatefulEvaluator<InputType, OutputType, CloneableSerializable> statefulEvaluator = this.getStatefulEvaluator();
        statefulEvaluator.setState(this.stateWrapper.getInternalState());
        CogxelState cogxels = modelState.getCogxels();
        this.input = this.getInputConverter().fromCogxels(cogxels);
    }

    @Override
    public CognitiveModuleState writeState(CognitiveModelState modelState) {
        CogxelState cogxels = modelState.getCogxels();
        this.getOutputConverter().toCogxels(this.output, cogxels);
        this.output = null;
        StatefulEvaluator<InputType, OutputType, CloneableSerializable> statefulEvaluator = this.getStatefulEvaluator();
        this.stateWrapper.setInternalState(statefulEvaluator.getState());
        return this.stateWrapper;
    }

    public StatefulEvaluator<InputType, OutputType, CloneableSerializable> getStatefulEvaluator() {
        return (StatefulEvaluator)this.getEvaluator();
    }
}

