/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.framework.learning;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.framework.CognitiveModel;
import gov.sandia.cognition.framework.CognitiveModelInput;
import gov.sandia.cognition.framework.CognitiveModelState;
import gov.sandia.cognition.framework.learning.CognitiveModuleFactoryLearner;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModuleFactory;
import gov.sandia.cognition.framework.learning.EvaluatorBasedCognitiveModuleSettings;
import gov.sandia.cognition.framework.learning.converter.CogxelConverter;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;
import java.util.LinkedList;

public class EvaluatorBasedCognitiveModuleFactoryLearner<InputType, OutputType, LearningDataType>
implements CognitiveModuleFactoryLearner,
CloneableSerializable {
    private BatchLearner<? super Collection<LearningDataType>, ? extends Evaluator<? super InputType, ? extends OutputType>> learner;
    private CogxelConverter<InputType> inputConverter;
    private CogxelConverter<OutputType> outputConverter;
    private CogxelConverter<LearningDataType> learningDataConverter;
    private String name;
    public static final String DEFAULT_NAME = "Learned Evaluator-based Cognitive Module";

    public EvaluatorBasedCognitiveModuleFactoryLearner() {
        this(null, DEFAULT_NAME);
    }

    public EvaluatorBasedCognitiveModuleFactoryLearner(BatchLearner<? super Collection<LearningDataType>, ? extends Evaluator<InputType, OutputType>> learner, String name) {
        this(learner, name, null, null, null);
    }

    public EvaluatorBasedCognitiveModuleFactoryLearner(BatchLearner<? super Collection<LearningDataType>, ? extends Evaluator<? super InputType, ? extends OutputType>> learner, String name, CogxelConverter<InputType> inputConverter, CogxelConverter<OutputType> outputConverter, CogxelConverter<LearningDataType> learningDataConverter) {
        this.setLearner(learner);
        this.setName(name);
        this.setInputConverter(inputConverter);
        this.setOutputConverter(outputConverter);
        this.setLearningDataConverter(learningDataConverter);
    }

    public EvaluatorBasedCognitiveModuleFactoryLearner(EvaluatorBasedCognitiveModuleFactoryLearner<InputType, OutputType, LearningDataType> other) {
        this((BatchLearner)ObjectUtil.cloneSafe(other.getLearner()), other.getName(), other.getInputConverter().clone(), other.getOutputConverter().clone(), other.getLearningDataConverter().clone());
    }

    public EvaluatorBasedCognitiveModuleFactoryLearner<InputType, OutputType, LearningDataType> clone() {
        return new EvaluatorBasedCognitiveModuleFactoryLearner<InputType, OutputType, LearningDataType>(this);
    }

    @Override
    public EvaluatorBasedCognitiveModuleFactory<InputType, OutputType> learn(CognitiveModel model, Collection<? extends Collection<? extends CognitiveModelInput>> datasets) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        if (datasets == null || datasets.size() <= 0) {
            throw new IllegalArgumentException("dataSets is null");
        }
        if (this.getLearner() == null) {
            throw new IllegalStateException("Learner is null");
        }
        if (this.getInputConverter() == null) {
            throw new IllegalStateException("Input converter is null");
        }
        if (this.getLearningDataConverter() == null) {
            throw new IllegalStateException("Learning data converter is null");
        }
        CogxelConverter<LearningDataType> converter = this.getLearningDataConverter().clone();
        converter.setSemanticIdentifierMap(model.getSemanticIdentifierMap());
        LinkedList<LearningDataType> learningSet = new LinkedList<LearningDataType>();
        for (Collection<? extends CognitiveModelInput> collection : datasets) {
            model.resetCognitiveState();
            for (CognitiveModelInput cognitiveModelInput : collection) {
                model.update(cognitiveModelInput);
                CognitiveModelState state = model.getCurrentState();
                LearningDataType example = converter.fromCogxels(state.getCogxels());
                learningSet.add(example);
            }
        }
        Evaluator learned = (Evaluator)this.getLearner().learn(learningSet);
        EvaluatorBasedCognitiveModuleSettings<InputType, OutputType> evaluatorBasedCognitiveModuleSettings = new EvaluatorBasedCognitiveModuleSettings<InputType, OutputType>(learned, this.getInputConverter(), this.getOutputConverter());
        return new EvaluatorBasedCognitiveModuleFactory<InputType, OutputType>(evaluatorBasedCognitiveModuleSettings, this.getName());
    }

    public BatchLearner<? super Collection<LearningDataType>, ? extends Evaluator<? super InputType, ? extends OutputType>> getLearner() {
        return this.learner;
    }

    public void setLearner(BatchLearner<? super Collection<LearningDataType>, ? extends Evaluator<? super InputType, ? extends OutputType>> learner) {
        this.learner = learner;
    }

    public CogxelConverter<InputType> getInputConverter() {
        return this.inputConverter;
    }

    public void setInputConverter(CogxelConverter<InputType> inputConverter) {
        this.inputConverter = inputConverter;
    }

    public CogxelConverter<OutputType> getOutputConverter() {
        return this.outputConverter;
    }

    public void setOutputConverter(CogxelConverter<OutputType> outputConverter) {
        this.outputConverter = outputConverter;
    }

    public CogxelConverter<LearningDataType> getLearningDataConverter() {
        return this.learningDataConverter;
    }

    public void setLearningDataConverter(CogxelConverter<LearningDataType> learningDataConverter) {
        this.learningDataConverter = learningDataConverter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

