/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.data.convert.number;

import gov.sandia.cognition.data.convert.AbstractReverseCachedDataConverter;
import gov.sandia.cognition.data.convert.AbstractReversibleDataConverter;

public class DefaultBooleanToNumberConverter
extends AbstractReverseCachedDataConverter<Boolean, Number, Reverse> {
    public static final double DEFAULT_TRUE_VALUE = 1.0;
    public static final double DEFAULT_FALSE_VALUE = -1.0;
    public static final double DEFAULT_NULL_VALUE = 0.0;
    protected Number trueValue;
    protected Number falseValue;
    protected Number nullValue;

    public DefaultBooleanToNumberConverter() {
        this(1.0, -1.0, 0.0);
    }

    public DefaultBooleanToNumberConverter(Number trueValue, Number falseValue, Number nullValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
        this.nullValue = nullValue;
    }

    public Number evaluate(Boolean input) {
        return this.convertToNumber(input);
    }

    public Number convertToNumber(Boolean input) {
        if (input == null) {
            return this.getNullValue();
        }
        if (input.booleanValue()) {
            return this.getTrueValue();
        }
        return this.getFalseValue();
    }

    public Boolean convertToBoolean(Number input) {
        if (input == null) {
            return null;
        }
        double value = input.doubleValue();
        if (this.nullValue != null && this.nullValue.equals(value)) {
            return null;
        }
        if (Math.abs(value - this.trueValue.doubleValue()) <= Math.abs(value - this.falseValue.doubleValue())) {
            return true;
        }
        return false;
    }

    @Override
    protected Reverse createReverse() {
        return new Reverse();
    }

    public Number getTrueValue() {
        return this.trueValue;
    }

    public void setTrueValue(Number trueValue) {
        this.trueValue = trueValue;
    }

    public Number getFalseValue() {
        return this.falseValue;
    }

    public void setFalseValue(Number falseValue) {
        this.falseValue = falseValue;
    }

    public Number getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(Number nullValue) {
        this.nullValue = nullValue;
    }

    public class Reverse
    extends AbstractReversibleDataConverter<Number, Boolean> {
        public Boolean evaluate(Number input) {
            return DefaultBooleanToNumberConverter.this.convertToBoolean(input);
        }

        @Override
        public DefaultBooleanToNumberConverter reverse() {
            return DefaultBooleanToNumberConverter.this;
        }
    }
}

