/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.data.convert.vector;

import gov.sandia.cognition.data.convert.DataConverter;
import gov.sandia.cognition.data.convert.vector.AbstractToVectorEncoder;
import gov.sandia.cognition.math.matrix.Vector;

public class NumberConverterToVectorAdapter<InputType>
extends AbstractToVectorEncoder<InputType> {
    protected DataConverter<? super InputType, ? extends Number> converter;

    public NumberConverterToVectorAdapter() {
        this((DataConverter<InputType, Number>)null);
    }

    public NumberConverterToVectorAdapter(DataConverter<? super InputType, ? extends Number> converter) {
        this.setConverter(converter);
    }

    @Override
    public void encode(InputType object, Vector vector, int index) {
        Number number = (Number)this.getConverter().evaluate(object);
        vector.setElement(index, number == null ? 0.0 : number.doubleValue());
    }

    @Override
    public int getOutputDimensionality() {
        return 1;
    }

    public DataConverter<? super InputType, ? extends Number> getConverter() {
        return this.converter;
    }

    public void setConverter(DataConverter<? super InputType, ? extends Number> converter) {
        this.converter = converter;
    }
}

