/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.data.convert.vector;

import gov.sandia.cognition.data.convert.AbstractDataConverter;
import gov.sandia.cognition.data.convert.vector.DataToVectorEncoder;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFactoryContainer;

public abstract class AbstractToVectorEncoder<InputType>
extends AbstractDataConverter<InputType, Vector>
implements DataToVectorEncoder<InputType>,
VectorFactoryContainer {
    protected VectorFactory<?> vectorFactory;

    public AbstractToVectorEncoder() {
        this(VectorFactory.getDefault());
    }

    public AbstractToVectorEncoder(VectorFactory<?> vectorFactory) {
        this.setVectorFactory(vectorFactory);
    }

    public Vector evaluate(InputType input) {
        Vector result = this.getVectorFactory().createVector(this.getOutputDimensionality());
        this.encode(input, result);
        return result;
    }

    @Override
    public void encode(InputType object, Vector vector) {
        this.encode(object, vector, 0);
    }

    public VectorFactory<?> getVectorFactory() {
        return this.vectorFactory;
    }

    public void setVectorFactory(VectorFactory<?> vectorFactory) {
        this.vectorFactory = vectorFactory;
    }
}

