/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.parser;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModulesDescriptor;
import de.smartics.maven.plugin.jboss.modules.parser.ModulesXmlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.JDOMException;

public final class ModulesXmlLocator {
    private final ModulesXmlParser parser = new ModulesXmlParser();
    private final String targetSlot;

    public ModulesXmlLocator(String targetSlot) {
        this.targetSlot = StringUtils.isNotBlank((String)targetSlot) && !"main".equals(targetSlot) ? targetSlot : null;
    }

    public List<ModulesDescriptor> discover(ClassLoader classLoader, List<File> rootDirectories) throws IOException {
        ArrayList<ModulesDescriptor> modules = new ArrayList<ModulesDescriptor>();
        for (File rootDirectory : rootDirectories) {
            this.loadModules(modules, rootDirectory);
        }
        if (this.targetSlot != null) {
            for (ModulesDescriptor module : modules) {
                module.applyDefaultSlot(this.targetSlot);
            }
        }
        return modules;
    }

    private void loadModules(List<ModulesDescriptor> modules, URL url, List<String> fileList) throws IOException {
        for (String file : fileList) {
            if (!file.endsWith(".xml")) continue;
            URL fileUrl = new URL(url.toExternalForm() + '/' + file);
            BufferedInputStream input = new BufferedInputStream(fileUrl.openStream());
            String urlString = fileUrl.toExternalForm();
            try {
                ModulesDescriptor descriptor = this.parser.parse(urlString, input);
                modules.add(descriptor);
            }
            catch (JDOMException e) {
                throw new IOException("Cannot parse XML file: " + urlString, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    private void loadModules(List<ModulesDescriptor> modules, File rootDirectory) throws IOException {
        File[] fileList;
        for (File file : fileList = rootDirectory.listFiles()) {
            if (!file.getName().endsWith(".xml")) continue;
            BufferedInputStream input = new BufferedInputStream(FileUtils.openInputStream((File)file));
            String fileId = file.getAbsolutePath();
            try {
                ModulesDescriptor descriptor = this.parser.parse(fileId, input);
                modules.add(descriptor);
            }
            catch (JDOMException e) {
                throw new IOException("Cannot parse XML file: " + fileId, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }
}

