/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.aether.artifact.Artifact;

public enum SlotStrategy {
    MAIN("main"),
    VERSION_MAJOR("version-major");

    public static final String MAIN_SLOT = "main";
    private String id;

    private SlotStrategy(String id) {
        this.id = id;
    }

    public static SlotStrategy fromString(String id) throws IllegalArgumentException {
        for (SlotStrategy strategy : SlotStrategy.values()) {
            if (!id.equals(strategy.id)) continue;
            return strategy;
        }
        throw new IllegalArgumentException(String.format("Invalid slot strategy '%s'. Allowed values are: %s", id, Arrays.toString((Object[])SlotStrategy.values())));
    }

    public String toString() {
        return this.id;
    }

    public String calcSlot(Artifact artifact, String defaultSlot) {
        if (this == VERSION_MAJOR) {
            String versionString = this.calcVersion(artifact);
            int majorVersion = this.getMajorVersion(versionString);
            String slot = !StringUtils.isBlank((String)defaultSlot) && !MAIN_SLOT.equals(defaultSlot) ? defaultSlot + majorVersion : String.valueOf(majorVersion);
            return slot;
        }
        return StringUtils.isBlank((String)defaultSlot) ? MAIN_SLOT : defaultSlot;
    }

    private int getMajorVersion(String version) {
        int index = version.indexOf("-");
        String mainPart = index > 0 ? version.substring(0, index) : version;
        index = mainPart.indexOf(46);
        return Integer.valueOf(index > 0 ? mainPart.substring(0, index) : mainPart);
    }

    public String calcSlot(String defaultSlot, String moduleSlot, Artifact artifact) {
        String fallBackSlot = StringUtils.isBlank((String)moduleSlot) ? defaultSlot : moduleSlot;
        String slot = this.calcSlot(artifact, fallBackSlot);
        return slot;
    }

    private String calcVersion(Artifact artifact) {
        if (artifact != null) {
            return artifact.getVersion();
        }
        return "VersionX";
    }
}

