/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public final class ModuleMap {
    private final List<ModuleDescriptor> modules;
    private final Multimap<ModuleDescriptor, Dependency> module2Dependencies = HashMultimap.create();
    private final Map<DependencyKey, ModuleDescriptor> dependency2Module = new HashMap<DependencyKey, ModuleDescriptor>();

    public ModuleMap() {
        this(new ArrayList<ModuleDescriptor>());
    }

    public ModuleMap(List<ModuleDescriptor> modules) {
        this.modules = modules;
    }

    public ModuleMap(List<ModuleDescriptor> modulesDescriptors, Collection<Dependency> dependencies) {
        this.modules = new ArrayList<ModuleDescriptor>(modulesDescriptors != null ? modulesDescriptors : new ArrayList());
        this.initDependencies(dependencies);
    }

    private void initDependencies(Collection<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            this.add(dependency);
        }
    }

    public synchronized Map<ModuleDescriptor, List<Dependency>> toMap() {
        LinkedHashMap<ModuleDescriptor, List<Dependency>> map = new LinkedHashMap<ModuleDescriptor, List<Dependency>>();
        for (Map.Entry entry : this.module2Dependencies.asMap().entrySet()) {
            ArrayList list = new ArrayList((Collection)entry.getValue());
            map.put((ModuleDescriptor)entry.getKey(), list);
        }
        return map;
    }

    public synchronized ModuleDescriptor add(Dependency dependency) {
        DependencyKey key = new DependencyKey(dependency);
        ModuleDescriptor alreadyStoredModule = this.dependency2Module.get(key);
        if (alreadyStoredModule != null) {
            return alreadyStoredModule;
        }
        ModuleDescriptor module = this.calcModule(key);
        this.storeArtifact(module, dependency);
        return module;
    }

    private ModuleDescriptor calcModule(DependencyKey key) {
        ModuleDescriptor alreadyStoredModule = this.dependency2Module.get(key);
        if (alreadyStoredModule != null) {
            return alreadyStoredModule;
        }
        for (ModuleDescriptor module : this.modules) {
            MatchContext matchContext = module.match(key.dependency.getArtifact());
            if (!matchContext.isMatched()) continue;
            if (matchContext.hasGroupMatch()) {
                ModuleDescriptor newModule = this.createModule(matchContext, module);
                return newModule;
            }
            return module;
        }
        ModuleDescriptor module = this.createModule(key.dependency);
        return module;
    }

    private void storeArtifact(ModuleDescriptor module, Dependency dependency) {
        if (!module.getDirectives().getSkip().booleanValue()) {
            if (this.module2Dependencies.containsKey((Object)module)) {
                for (ModuleDescriptor current : this.module2Dependencies.keySet()) {
                    if (!module.equals(current)) continue;
                    current.merge(module);
                }
            }
            this.module2Dependencies.put((Object)module, (Object)dependency);
            this.dependency2Module.put(new DependencyKey(dependency), module);
        }
    }

    private ModuleDescriptor createModule(MatchContext matchContext, ModuleDescriptor originalModule) {
        String name = matchContext.translateName(originalModule.getName());
        ModuleDescriptor module = ModuleDescriptor.copy(name, originalModule);
        return module;
    }

    private ModuleDescriptor createModule(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String name = ModuleMap.createName(groupId, artifactId);
        ModuleDescriptor module = ModuleDescriptor.create(name);
        return module;
    }

    static String createName(String groupId, String artifactId) throws NullPointerException, IllegalArgumentException {
        Arg.checkNotBlank("groupId", groupId);
        Arg.checkNotBlank("artifactId", artifactId);
        String name = groupId.equals(artifactId) || groupId.endsWith('.' + artifactId) ? groupId : groupId + '.' + artifactId;
        return name;
    }

    public synchronized ModuleDescriptor getModule(Dependency dependency) {
        DependencyKey key = new DependencyKey(dependency);
        ModuleDescriptor module = this.dependency2Module.get(key);
        if (module == null) {
            module = this.calcModule(key);
        }
        return module;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(2048);
        for (Map.Entry entry : this.module2Dependencies.asMap().entrySet()) {
            ModuleDescriptor module = (ModuleDescriptor)entry.getKey();
            buffer.append('\n').append(module.getName()).append(':');
            for (Dependency dependency : (Collection)entry.getValue()) {
                buffer.append("\n  ").append(dependency.getArtifact().getArtifactId());
            }
        }
        return buffer.toString();
    }

    private static final class DependencyKey {
        private final Dependency dependency;

        private DependencyKey(Dependency dependency) {
            this.dependency = dependency;
        }

        public int hashCode() {
            return this.dependency.getArtifact().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DependencyKey other = (DependencyKey)object;
            Artifact artifact = this.dependency.getArtifact();
            Artifact otherArtifact = other.dependency.getArtifact();
            return this.checkArtifactsWithoutProperties(artifact, otherArtifact);
        }

        private boolean checkArtifactsWithoutProperties(Artifact artifact, Artifact otherArtifact) {
            return artifact.getArtifactId().equals(otherArtifact.getArtifactId()) && artifact.getGroupId().equals(otherArtifact.getGroupId()) && artifact.getVersion().equals(otherArtifact.getVersion()) && artifact.getExtension().equals(otherArtifact.getExtension()) && artifact.getClassifier().equals(otherArtifact.getClassifier()) && ObjectUtils.equals((Object)artifact.getFile(), (Object)otherArtifact.getFile());
        }

        public String toString() {
            return this.dependency.toString();
        }
    }
}

