/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ModuleMap;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.domain.TransitiveDependencyResolver;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.slf4j.Logger;

public final class ExecutionContext {
    private final Logger log;
    private final File targetFolder;
    private final TransitiveDependencyResolver resolver;
    private final SlotStrategy slotStrategy;
    private final String defaultSlot;
    private final String globalModuleDependency;
    private final ModuleMap moduleMap;

    private ExecutionContext(Builder builder) {
        this.log = builder.log;
        this.targetFolder = builder.targetFolder;
        this.resolver = builder.resolver;
        this.slotStrategy = builder.slotStrategy;
        this.defaultSlot = builder.defaultSlot;
        this.moduleMap = builder.moduleMap;
        this.globalModuleDependency = builder.globalModuleDependency != null ? builder.globalModuleDependency : "";
    }

    public Logger getLog() {
        return this.log;
    }

    public File getTargetFolder() {
        return this.targetFolder;
    }

    public TransitiveDependencyResolver getResolver() {
        return this.resolver;
    }

    public SlotStrategy getSlotStrategy() {
        return this.slotStrategy;
    }

    public String getDefaultSlot() {
        return this.defaultSlot;
    }

    public ModuleMap getModuleMap() {
        return this.moduleMap;
    }

    public String getGlobalModuleDependency() {
        return this.globalModuleDependency;
    }

    public List<Dependency> resolve(Dependency dependency) {
        try {
            return this.resolver.resolveDirect(dependency);
        }
        catch (DependencyResolutionException e) {
            this.log.error("Cannot resolve dependency '" + dependency.getArtifact().getArtifactId() + "': " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public ModuleDescriptor getModule(Dependency dependency) throws IllegalArgumentException {
        ModuleDescriptor module = this.moduleMap.getModule(dependency);
        if (module == null) {
            throw new IllegalArgumentException("Cannot find module for dependency: " + dependency);
        }
        return module;
    }

    public static final class Builder {
        private Logger log;
        private File targetFolder;
        private TransitiveDependencyResolver resolver;
        private SlotStrategy slotStrategy;
        private String defaultSlot;
        private ModuleMap moduleMap;
        private String globalModuleDependency;

        public Builder with(Logger log) {
            this.log = log;
            return this;
        }

        public Builder withTargetFolder(File targetFolder) {
            this.targetFolder = targetFolder;
            return this;
        }

        public Builder with(TransitiveDependencyResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder with(SlotStrategy slotStrategy) {
            this.slotStrategy = slotStrategy;
            return this;
        }

        public Builder withDefaultSlot(String defaultSlot) {
            this.defaultSlot = defaultSlot;
            return this;
        }

        public Builder with(ModuleMap moduleMap) {
            this.moduleMap = moduleMap;
            return this;
        }

        public Builder withGlobalModuleDependency(String globalModuleDependency) {
            this.globalModuleDependency = globalModuleDependency;
            return this;
        }

        public ExecutionContext build() throws NullPointerException {
            Arg.checkNotNull("targetFolder", this.targetFolder);
            Arg.checkNotNull("resolver", this.resolver);
            Arg.checkNotNull("slotStrategy", this.slotStrategy);
            Arg.checkNotNull("moduleMap", this.moduleMap);
            return new ExecutionContext(this);
        }
    }
}

