/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleClusion;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class ModuleMatcher {
    private final List<ModuleClusion> includes;
    private final List<ModuleClusion> excludes;

    private ModuleMatcher(Builder builder) {
        this.includes = builder.includes;
        this.excludes = builder.excludes;
    }

    public List<ModuleClusion> getIncludes() {
        return this.includes;
    }

    public List<ModuleClusion> getExcludes() {
        return this.excludes;
    }

    public boolean matches(String name) {
        boolean included = this.matches(this.includes, name, true);
        if (included) {
            boolean excluded = this.matches(this.excludes, name, false);
            return !excluded;
        }
        return included;
    }

    private boolean matches(List<ModuleClusion> cludes, String name, boolean defaultValue) {
        if (cludes.isEmpty()) {
            return defaultValue;
        }
        for (ModuleClusion clusion : cludes) {
            if (!clusion.match(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static final class Builder {
        private final List<ModuleClusion> includes = new ArrayList<ModuleClusion>();
        private final List<ModuleClusion> excludes = new ArrayList<ModuleClusion>();

        public void addInclude(ModuleClusion include) throws NullPointerException {
            this.includes.add(Arg.checkNotNull("include", include));
        }

        public void addExclude(ModuleClusion exclude) throws NullPointerException {
            this.excludes.add(Arg.checkNotNull("exclude", exclude));
        }

        public ModuleMatcher build() {
            return new ModuleMatcher(this);
        }
    }
}

