/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleMatcher;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class DependenciesDescriptor {
    private final ModuleMatcher matcher;
    private final String slot;
    private final Boolean export;
    private final String services;
    private final Boolean optional;
    private final String importsXml;
    private final String exportsXml;

    private DependenciesDescriptor(Builder builder) {
        this.matcher = builder.matcher;
        this.slot = builder.slot;
        this.export = builder.export;
        this.services = builder.services;
        this.optional = builder.optional;
        this.importsXml = builder.importsXml;
        this.exportsXml = builder.exportsXml;
    }

    public ModuleMatcher getMatcher() {
        return this.matcher;
    }

    public String getSlot() {
        return this.slot;
    }

    public Boolean getExport() {
        return this.export;
    }

    public String getServices() {
        return this.services;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public String getImportsXml() {
        return this.importsXml;
    }

    public String getExportsXml() {
        return this.exportsXml;
    }

    public boolean matches(String name) {
        return this.matcher.matches(name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static final class Builder {
        private ModuleMatcher matcher;
        private String slot;
        private Boolean export;
        private String services;
        private Boolean optional;
        private String importsXml;
        private String exportsXml;

        public Builder with(ModuleMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder withSlot(String slot) {
            if (StringUtils.isNotBlank((String)slot)) {
                this.slot = slot;
            }
            return this;
        }

        public Builder withExport(String export) {
            if (StringUtils.isNotBlank((String)export)) {
                this.export = Boolean.parseBoolean(export);
            }
            return this;
        }

        public Builder withServices(String services) {
            if (StringUtils.isNotBlank((String)services)) {
                this.services = services;
            }
            return this;
        }

        public Builder withOptional(String optional) {
            if (StringUtils.isNotBlank((String)optional)) {
                this.optional = Boolean.parseBoolean(optional);
            }
            return this;
        }

        public Builder withImportsXml(String importsXml) {
            this.importsXml = importsXml;
            return this;
        }

        public Builder withExportsXml(String exportsXml) {
            this.exportsXml = exportsXml;
            return this;
        }

        public void merge(String moduleName, DependenciesDescriptor descriptor) {
            this.slot = this.merge("slot", moduleName, this.slot, descriptor.slot);
            this.export = this.merge("export", moduleName, this.export, descriptor.export);
            this.services = this.merge("services", moduleName, this.services, descriptor.services);
            this.optional = this.merge("optional", moduleName, this.optional, descriptor.optional);
            this.importsXml = this.merge("imports", moduleName, this.importsXml, descriptor.importsXml);
            this.exportsXml = this.merge("exports", moduleName, this.exportsXml, descriptor.exportsXml);
        }

        private <T> T merge(String property, String moduleName, T value1, T value2) {
            if (value1 != null && value2 != null && !value1.equals(value2)) {
                throw new IllegalArgumentException(String.format("Module %s: Cannot merge %s: '%s' differs from '%s'.", moduleName, property, value1, value2));
            }
            return value1 == null ? value2 : value1;
        }

        public DependenciesDescriptor build() {
            if (this.matcher == null) {
                this.matcher = new ModuleMatcher.Builder().build();
            }
            if (this.export == null) {
                this.export = Boolean.FALSE;
            }
            if (this.optional == null) {
                this.optional = Boolean.FALSE;
            }
            return new DependenciesDescriptor(this);
        }
    }
}

