/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.DependenciesDescriptor;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class ApplyToDependencies {
    private final List<DependenciesDescriptor> descriptors;

    private ApplyToDependencies(Builder builder) {
        this.descriptors = builder.descriptors;
    }

    public List<DependenciesDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    public DependenciesDescriptor getDescriptorThatMatches(String name) {
        DependenciesDescriptor.Builder builder = new DependenciesDescriptor.Builder();
        for (DependenciesDescriptor descriptor : this.descriptors) {
            if (!descriptor.matches(name)) continue;
            builder.merge(name, descriptor);
        }
        DependenciesDescriptor descriptor = builder.build();
        return descriptor;
    }

    public void merge(ApplyToDependencies applyToDependencies) {
        this.descriptors.addAll(applyToDependencies.descriptors);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static final class Builder {
        private final List<DependenciesDescriptor> descriptors = new ArrayList<DependenciesDescriptor>();

        public void add(DependenciesDescriptor descriptor) throws NullPointerException {
            this.descriptors.add(Arg.checkNotNull("descriptor", descriptor));
        }

        public ApplyToDependencies build() {
            return new ApplyToDependencies(this);
        }
    }
}

