/*******************************************************************************
 * Copyright (c) 2010, 2014 Sonatype, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sonatype, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.aether.resolution;

/**
 * Thrown in case of a unresolvable dependencies.
 */
public class DependencyResolutionException
        extends RuntimeException
{

    /**
     * Creates a new exception with the specified result and cause.
     *
     * @param cause The exception that caused this one, may be {@code null}.
     */
    public DependencyResolutionException(Throwable cause)
    {
        super(getMessage(cause), cause);
    }

    /**
     * Creates a new exception with the specified result, detail message and cause.
     *
     * @param message The detail message, may be {@code null}.
     * @param cause   The exception that caused this one, may be {@code null}.
     */
    public DependencyResolutionException(String message, Throwable cause)
    {
        super(message, cause);
    }

    private static String getMessage(Throwable cause)
    {
        String msg = null;
        if (cause != null)
        {
            msg = cause.getMessage();
        }
        if (msg == null || msg.length() <= 0)
        {
            msg = "Could not resolve transitive dependencies";
        }
        return msg;
    }
}
