package org.eclipse.aether.graph;

import org.eclipse.aether.artifact.Artifact;

import java.util.*;

/**
 * In aether, this is a class, but for our integration work, we need it to be an interface.
 */
public interface Dependency
{
    /**
     * Gets the artifact being depended on.
     *
     * @return The artifact, never {@code null}.
     */
    Artifact getArtifact();

    /**
     * Gets the scope of the dependency. The scope defines in which context this dependency is relevant.
     *
     * @return The scope or an empty string if not set, never {@code null}.
     */
    String getScope();

    /**
     * Indicates whether this dependency is optional or not. Optional dependencies can be ignored in some contexts.
     *
     * @return {@code true} if the dependency is (definitively) optional, {@code false} otherwise.
     */
    boolean isOptional();

    /**
     * Gets the exclusions for this dependency. Exclusions can be used to remove transitive dependencies during
     * resolution.
     *
     * @return The (read-only) exclusions, never {@code null}.
     */
    Collection<Exclusion> getExclusions();
}
