package gov.raptor.gradle.plugins.jbossmodules

import org.eclipse.aether.artifact.Artifact
import org.eclipse.aether.graph.Dependency
import org.eclipse.aether.graph.Exclusion
import org.gradle.api.artifacts.ResolvedDependency

/**
 * Stand-in class to map Maven Dependency and Gradle ResolvedDependency into a single object.
 * This is required to merge our gradle environment into the maven environment expected by the original plugin code.
 */
class MappedDependency implements Dependency, ResolvedDependency {
    @Delegate
    private ResolvedDependency delegate

    private MappedArtifact mappedArtifact

    MappedDependency(ResolvedDependency delegate) {
        this.delegate = delegate
        mappedArtifact = new MappedArtifact(delegate)
    }

    ResolvedDependency getResolvedDependency() {
        return delegate
    }

    @Override
    Artifact getArtifact() {
        return mappedArtifact
    }

    @Override
    String getScope() {
        return 'compile'
    }

    @Override
    boolean isOptional() {
        return false
    }

    @Override
    Collection<Exclusion> getExclusions() {
        return []
    }

    @Override
    String toString() {
        return "MappedDependency{" +
                "delegate=" + delegate +
                '}'
    }
}
