package gov.raptor.gradle.plugins.jbossmodules

import org.eclipse.aether.artifact.Artifact
import org.gradle.api.artifacts.ResolvedDependency

/**
 * Stand-in class to map Maven Artifact and Gradle ResolvedDependency into a single object.
 * This is required to merge our gradle environment into the maven environment expected by the original plugin code.
 */
class MappedArtifact implements Artifact, ResolvedDependency {

    @Delegate
    private ResolvedDependency delegate

    MappedArtifact(ResolvedDependency delegate) {
        this.delegate = delegate
    }

    ResolvedDependency getResolvedDependency() {
        return delegate
    }

    @Override
    String getGroupId() {
        return delegate.getModuleGroup()
    }

    @Override
    String getArtifactId() {
        return delegate.getModuleName()
    }

    @Override
    String getVersion() {
        return delegate.getModuleVersion()
    }

    @Override
    String getClassifier() {
        // For now, assume each dependency yields a single artifact
        return delegate.getAllModuleArtifacts()[0].classifier
    }

    @Override
    String getExtension() {
        // For now, assume each dependency yields a single artifact
        return delegate.getAllModuleArtifacts()[0].extension
    }

    @Override
    File getFile() {
        // For now, assume each dependency yields a single artifact
        return delegate.getAllModuleArtifacts()[0].file
    }

    String toString() {
        return delegate.toString()
    }
}
