package gov.raptor.gradle.plugins.jbossmodules

import org.gradle.api.Plugin
import org.gradle.api.internal.project.ProjectInternal

/**
 * @author Proprietary information subject to the terms of a Non-Disclosure Agreement
 */
class JbossModulesPlugin implements Plugin<ProjectInternal> {

    private static final String GENERATE_TASK_NAME = "generateJbossModules"

    @Override
    void apply(ProjectInternal project) {

        // Add our extension object to collect our configuration
        project.extensions.create("jbossmodules", JbossModulesExtension, project)

        createTasks(project)
    }

    private void createTasks(ProjectInternal project) {
        GenerateJbossModulesTask task = project.tasks.create(GENERATE_TASK_NAME, GenerateJbossModulesTask)
        task.setDescription("Generate the Jboss Modules definitions from the project dependencies")
    }
}
