package gov.raptor.gradle.plugins.jbossmodules

import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion
import de.smartics.maven.plugin.jboss.modules.domain.TransitiveDependencyResolver
import org.eclipse.aether.graph.Dependency
import org.eclipse.aether.resolution.DependencyResolutionException
import org.gradle.api.artifacts.ResolvedDependency

/**
 * Stand-in class to stub out dependency resolution (since gradle has done that for us).
 */
class DirectDependencyResolver implements TransitiveDependencyResolver {

    private final List<ArtifactClusion> dependencyExcludes

    DirectDependencyResolver(List<ArtifactClusion> dependencyExcludes) {
        this.dependencyExcludes = dependencyExcludes
    }

    @Override
    List<Dependency> resolve(Dependency dependency) throws DependencyResolutionException {
        return null // Not used
    }

    @Override
    List<Dependency> resolveDirect(Dependency dependency) throws DependencyResolutionException {
        // The dependency we'll be given is actually a MappedDependency, so we can get the resolved dependency from it
        MappedDependency md = (MappedDependency) dependency

        return md.getResolvedDependency().getChildren().findAll { c -> !dependencyExcluded(c) }.collect {
            new MappedDependency(it)
        }
    }

    @Override
    List<Dependency> resolve(List<Dependency> dependencies) throws DependencyResolutionException {
        return null // Not used
    }

    /**
     * Determine if this dependency should be excluded (pruned), which is determined by our dependency excludes.
     *
     * @param dep Dependency to test
     * @return {@code true} if the dependency should be pruned
     */
    private boolean dependencyExcluded(ResolvedDependency dep) {
        def artifact = new MappedArtifact(dep)
        return dependencyExcludes.grep { it.matches(artifact).isMatched() }
    }
}
