package gov.raptor.gradle.plugins.jbossmodules

import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion
import groovy.transform.ToString
import org.gradle.tooling.BuildException

/**
 * Handler for dependencyExcludes DSL.
 */
@ToString(includeNames = false, includePackage = false)
class DependencyExcludes {

    private static final String GROUP_ID = 'groupId'
    private static final String ARTIFACT_ID = 'artifactId'

    /**
     * A list of dependencies to be excluded from the transitive dependency collection process.
     */
    List<ArtifactClusion> excludes = []

    /**
     * Specify an exclusion using a simple string.
     *
     * If no ':' is present in the string, then the entire string is used as the group Id.
     *
     * @param notation String with pattern: <groupId>[:<artifactId>]
     */
    void exclude(String notation) {
        if (notation.contains(':')) {
            def strings = notation.split(':')
            add strings[0], strings[1]
        } else {
            add(notation, null)
        }
    }

    /**
     * Specify an exclusion using a map.  One or both of 'artifactId' and 'groupId' must be present as keys
     * in the map.  The value of either may be an regular expression.
     *
     * @param notation
     */
    void exclude(Map<String, String> notation) {
        if (!(notation.containsKey(GROUP_ID) || notation.containsKey(ARTIFACT_ID)))
            throw new BuildException("Exclusion must contain at least one of '$GROUP_ID' or '$ARTIFACT_ID'", null)

        add(notation['groupId'], notation['artifactId'])
    }

    private void add(String groupId, String artifactId) {
        excludes.add(ArtifactClusion.create(groupId, artifactId))
    }
}
