/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.generate;

import gov.nist.secauto.swid.builder.EntityBuilder;
import gov.nist.secauto.swid.builder.KnownVersionScheme;
import gov.nist.secauto.swid.builder.Role;
import gov.nist.secauto.swid.builder.SWIDBuilder;
import gov.nist.secauto.swid.builder.VersionScheme;
import gov.nist.secauto.swid.builder.resource.AbstractResourceCollectionBuilder;
import gov.nist.secauto.swid.builder.resource.HashAlgorithm;
import gov.nist.secauto.swid.builder.resource.file.FileBuilder;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import gov.nist.secauto.swid.plugin.model.Entity;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class MavenProjectSwidBuilderHelper {
    private MavenProjectSwidBuilderHelper() {
    }

    public static SWIDBuilder applyProjectMetadata(SWIDBuilder builder, MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        String name = project.getName();
        if (name == null) {
            StringBuilder str = new StringBuilder();
            str.append(groupId);
            str.append('-');
            str.append(artifactId);
            str.append('-');
            str.append(version);
            name = str.toString();
        }
        builder.name(name);
        builder.version(version);
        if (version.endsWith("SNAPSHOT")) {
            builder.versionScheme((VersionScheme)KnownVersionScheme.MULTIPART_NUMERIC_WITH_SUFFIX);
        } else {
            builder.versionScheme((VersionScheme)KnownVersionScheme.MULTIPART_NUMERIC);
        }
        builder.tagId(MavenProjectSwidBuilderHelper.generateTagId(project));
        return builder;
    }

    protected static String generateTagId(MavenProject project) {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        StringBuilder str = new StringBuilder();
        str.append(groupId);
        str.append('-');
        str.append(artifactId);
        str.append('-');
        str.append(version);
        if (version.endsWith("SNAPSHOT")) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'kkmmss");
            str.append("-");
            str.append(ZonedDateTime.now(ZoneId.of("UTC")).format(formatter));
        }
        return str.toString();
    }

    public static SWIDBuilder applyEntities(SWIDBuilder builder, List<Entity> entities) {
        for (Entity entity : entities) {
            EntityBuilder entityBuilder = EntityBuilder.create();
            if (entity.getName() != null) {
                entityBuilder.name(entity.getName());
            }
            if (entity.getRegid() != null) {
                entityBuilder.regid(entity.getRegid());
            }
            if (entity.getRoles() != null) {
                for (String roleValue : entity.getRoles()) {
                    entityBuilder.addRole(Role.lookupByName((String)roleValue));
                }
            }
            builder.addEntity(entityBuilder);
        }
        return builder;
    }

    public static void applyFileEnties(AbstractResourceCollectionBuilder<?> builder, String swidTagPath, List<FileEntry> swidFiles, Collection<HashAlgorithm> hashAlgorithms) throws NoSuchAlgorithmException, IOException {
        for (FileEntry entry : swidFiles) {
            Long size;
            FileBuilder fileBuilder = builder.newFileResource(entry.getRelativePathSegements(swidTagPath));
            String version = entry.getVersion();
            if (version != null) {
                fileBuilder.version(version);
            }
            if ((size = entry.getSize()) != null) {
                fileBuilder.size(size.longValue());
            }
            for (HashAlgorithm algorithm : hashAlgorithms) {
                fileBuilder.hash(algorithm, entry.getInputStream());
            }
        }
    }

    public static SWIDBuilder buildSwidTag(MavenProject project, String swidTagPath, List<Entity> entities, List<FileEntry> swidFiles) throws NoSuchAlgorithmException, IOException {
        SWIDBuilder builder = SWIDBuilder.create();
        MavenProjectSwidBuilderHelper.applyProjectMetadata(builder, project);
        if (entities != null && !entities.isEmpty()) {
            MavenProjectSwidBuilderHelper.applyEntities(builder, entities);
        }
        MavenProjectSwidBuilderHelper.applyFileEnties(builder.newPayload(), swidTagPath, swidFiles, Arrays.asList(HashAlgorithm.SHA_512, HashAlgorithm.SHA_256));
        return builder;
    }
}

