/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry.resource;

import gov.nist.secauto.swid.plugin.entry.AbstractFileEntryProcessor;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import gov.nist.secauto.swid.plugin.entry.FileFileEntry;
import gov.nist.secauto.swid.plugin.entry.FileSelectorPredicate;
import gov.nist.secauto.swid.plugin.entry.resource.ResourceFileEntry;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class ResourceFileEntryProcessor
extends AbstractFileEntryProcessor<Resource> {
    private IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
    private final String buildOutputDirectory;

    public ResourceFileEntryProcessor(String buildOutputDirectory, Log log) {
        super(log);
        Objects.requireNonNull(buildOutputDirectory);
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public void setIncludes(String[] includes) {
        this.selector.setIncludes(includes);
    }

    public void setExcludes(String[] excludes) {
        this.selector.setExcludes(excludes);
    }

    @Override
    public List<FileEntry> process(List<? extends Resource> resources) throws IOException {
        List<FileEntry> retval;
        List<FileEntry> processedResources = super.process(resources);
        List<FileEntry> processedClasses = this.generateClassFileEntries();
        int size = processedResources.size() + processedClasses.size();
        if (size == 0) {
            retval = Collections.emptyList();
        } else {
            retval = new ArrayList<FileEntry>(size);
            retval.addAll(processedResources);
            retval.addAll(processedClasses);
        }
        return retval;
    }

    private List<FileEntry> generateClassFileEntries() throws IOException {
        this.getLog().debug((CharSequence)("Processing classes: " + this.buildOutputDirectory));
        Path path = Paths.get(this.buildOutputDirectory, new String[0]);
        List<FileEntry> retval = path.toFile().exists() ? Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> new FileFileEntry((Path)p, path)).filter(new FileSelectorPredicate(this.selector)).collect(Collectors.toList()) : Collections.emptyList();
        return retval;
    }

    @Override
    protected Collection<? extends FileEntry> generateFileEntries(Resource resource) throws IOException {
        this.getLog().debug((CharSequence)("Processing resource: " + resource.getDirectory()));
        Path path = Paths.get(resource.getDirectory(), new String[0]);
        List retval = path.toFile().exists() ? Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> new ResourceFileEntry(resource, (Path)p)).filter(new FileSelectorPredicate(this.selector)).collect(Collectors.toList()) : Collections.emptyList();
        return retval;
    }
}

