/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry.resource;

import gov.nist.secauto.swid.plugin.entry.AbstractFileEntry;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.maven.model.Resource;

public class ResourceFileEntry
extends AbstractFileEntry {
    private final Resource resource;
    private final Path file;

    public ResourceFileEntry(Resource resource, Path file) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(file);
        this.resource = resource;
        this.file = file;
    }

    @Override
    public Path getBase() {
        return Paths.get(this.resource.getDirectory(), new String[0]);
    }

    @Override
    protected String getOutputBase() {
        return this.resource.getTargetPath();
    }

    @Override
    public Path getPath() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file.toFile());
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public Long getSize() {
        return this.file.toFile().length();
    }
}

