/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry.archive;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiveEntry;

public class ArtifactMap {
    private final Map<String, Artifact> artifactFileToArtifactMap;

    protected static Map<String, Artifact> initialize(MavenProject project) {
        HashMap<String, Artifact> retval = new HashMap<String, Artifact>();
        Artifact target = project.getArtifact();
        retval.put(target.getFile().getAbsolutePath(), target);
        project.getArtifacts().stream().filter(ArtifactMap.includeOnlyCompileAndRuntime()).forEach(a -> retval.put(a.getFile().getAbsolutePath(), (Artifact)a));
        return retval;
    }

    protected static Predicate<Artifact> includeOnlyCompileAndRuntime() {
        return new Predicate<Artifact>(){

            @Override
            public boolean test(Artifact artifact) {
                String scope = artifact.getScope();
                return "compile".equals(scope) || "runtime".equals(scope);
            }
        };
    }

    protected ArtifactMap(Map<String, Artifact> map) {
        this.artifactFileToArtifactMap = map;
    }

    public ArtifactMap(MavenProject project) {
        this(ArtifactMap.initialize(project));
    }

    public Artifact lookupArtifactForArchiveEntry(ArchiveEntry entry) {
        Path entryPath = Paths.get(entry.getResource().getName(), new String[0]);
        String path = entryPath.toString();
        return this.artifactFileToArtifactMap.get(path);
    }
}

