/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry.archive;

import gov.nist.secauto.swid.builder.resource.PathRelativizer;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class ArchiveFileEntry
implements FileEntry {
    private final ArchiveEntry archiveEntry;
    private final Artifact artifact;

    public ArchiveFileEntry(ArchiveEntry archiveEntry, Artifact artifact) {
        Objects.requireNonNull(archiveEntry, "archiveEntry");
        this.archiveEntry = archiveEntry;
        this.artifact = artifact;
    }

    @Override
    public Long getSize() {
        PlexusIoResource resource = this.archiveEntry.getResource();
        File file = null;
        if (resource instanceof PlexusIoFileResource) {
            file = ((PlexusIoFileResource)resource).getFile();
        }
        return file == null ? null : Long.valueOf(file.length());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.archiveEntry.getInputStream();
    }

    @Override
    public String getVersion() {
        String retval = null;
        if (this.artifact != null) {
            retval = this.artifact.getVersion();
        }
        return retval;
    }

    @Override
    public Path getPath() {
        PlexusIoResource resource = this.archiveEntry.getResource();
        File file = null;
        if (resource instanceof PlexusIoFileResource) {
            file = ((PlexusIoFileResource)resource).getFile();
        }
        return file == null ? null : file.toPath();
    }

    @Override
    public String getOutputRelativePath() {
        return this.archiveEntry.getName();
    }

    @Override
    public List<String> getRelativePathSegements(String swidTagPath) {
        return PathRelativizer.relativize((String)swidTagPath, (String)this.getOutputRelativePath());
    }

    @Override
    public FileInfo asFileInfo() {
        PlexusIoResource resource = this.archiveEntry.getResource();
        return resource;
    }
}

