/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry.archive;

import gov.nist.secauto.swid.plugin.entry.AbstractFileEntryProcessor;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import gov.nist.secauto.swid.plugin.entry.archive.ArchiveFileEntry;
import gov.nist.secauto.swid.plugin.entry.archive.ArtifactMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class ArchiveEntryFileEntryProcessor
extends AbstractFileEntryProcessor<ArchiveEntry> {
    private final ArtifactMap artifactMap;
    private IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();

    public ArchiveEntryFileEntryProcessor(MavenProject project, Log log) {
        super(log);
        this.artifactMap = new ArtifactMap(project);
    }

    public void setIncludes(String[] includes) {
        this.selector.setIncludes(includes);
    }

    public void setExcludes(String[] excludes) {
        this.selector.setExcludes(excludes);
    }

    protected Artifact lookupArtifact(ArchiveEntry entry) {
        return this.artifactMap.lookupArtifactForArchiveEntry(entry);
    }

    @Override
    protected Collection<? extends FileEntry> generateFileEntries(ArchiveEntry entry) throws IOException {
        Artifact artifact = this.lookupArtifact(entry);
        ArchiveFileEntry archiveFileEntry = new ArchiveFileEntry(entry, artifact);
        FileInfo fileInfo = archiveFileEntry.asFileInfo();
        Collection<Object> retval = fileInfo.isFile() ? (this.selector.isSelected(fileInfo) ? Collections.singleton(archiveFileEntry) : Collections.emptyList()) : Collections.emptyList();
        return retval;
    }
}

