/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry;

import gov.nist.secauto.swid.plugin.entry.FileEntry;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractFileEntryProcessor<T> {
    private final Log log;

    public AbstractFileEntryProcessor(Log log) {
        Objects.requireNonNull(log);
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public List<FileEntry> process(List<? extends T> resources) throws IOException {
        LinkedList<FileEntry> retval = new LinkedList<FileEntry>();
        for (T record : resources) {
            retval.addAll(this.generateFileEntries(record));
        }
        return retval;
    }

    protected abstract Collection<? extends FileEntry> generateFileEntries(T var1) throws IOException;
}

