/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin.entry;

import gov.nist.secauto.swid.builder.resource.PathRelativizer;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

public abstract class AbstractFileEntry
implements FileEntry {
    protected abstract Path getBase();

    @Override
    public abstract Path getPath();

    protected Path getRelativePath() {
        return this.getBase().relativize(this.getPath());
    }

    protected abstract String getOutputBase();

    @Override
    public String getOutputRelativePath() {
        StringBuilder builder = new StringBuilder();
        String base = this.getOutputBase();
        if (base != null) {
            builder.append(base);
            builder.append('/');
        }
        Path relativePath = this.getRelativePath();
        String relativePathString = relativePath.toString();
        String seperator = relativePath.getFileSystem().getSeparator();
        if (!"/".equals(seperator)) {
            relativePathString = relativePathString.replace(seperator, "/");
        }
        builder.append(relativePathString);
        return builder.toString();
    }

    @Override
    public List<String> getRelativePathSegements(String swidTagPath) {
        return PathRelativizer.relativize((String)swidTagPath, (String)this.getOutputRelativePath());
    }

    @Override
    public FileInfo asFileInfo() {
        return new ResourceFileInfo();
    }

    private class ResourceFileInfo
    implements FileInfo {
        private ResourceFileInfo() {
        }

        public String getName() {
            return AbstractFileEntry.this.getOutputRelativePath().toString();
        }

        public InputStream getContents() throws IOException {
            return AbstractFileEntry.this.getInputStream();
        }

        public boolean isFile() {
            return true;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isSymbolicLink() {
            return false;
        }
    }
}

