/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin;

import gov.nist.secauto.swid.builder.SWIDBuilder;
import gov.nist.secauto.swid.builder.ValidationException;
import gov.nist.secauto.swid.builder.output.CBOROutputHandler;
import gov.nist.secauto.swid.builder.output.OutputHandler;
import gov.nist.secauto.swid.builder.output.XMLOutputHandler;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import gov.nist.secauto.swid.plugin.entry.resource.ResourceFileEntryProcessor;
import gov.nist.secauto.swid.plugin.generate.MavenProjectSwidBuilderHelper;
import gov.nist.secauto.swid.plugin.model.Entity;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class SwidGenerateMojo
extends AbstractMojo {
    private static final List<String> DEFAULT_INCLUDES = Collections.singletonList("**/**");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/META-INF", property="outputDir", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="XML", required=true)
    private String tagFormat;
    @Parameter(defaultValue="SWIDTAG", required=true)
    private String tagPath;
    @Parameter(defaultValue="swid-tag", required=true)
    private String tagName;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<Entity> entities;

    public MavenProject getProject() {
        return this.project;
    }

    public String[] getIncludes() {
        List<String> retval = this.includes != null && !this.includes.isEmpty() ? this.includes : DEFAULT_INCLUDES;
        return retval.toArray(new String[retval.size()]);
    }

    public String[] getExcludes() {
        List<String> retval = this.excludes != null && !this.excludes.isEmpty() ? this.excludes : Collections.emptyList();
        return retval.toArray(new String[retval.size()]);
    }

    public File getSwidTagFile() throws MojoExecutionException {
        String tagFormat;
        File retval = new File(this.outputDirectory);
        if (!retval.exists() && !retval.mkdirs()) {
            throw new MojoExecutionException("Unable to create the directory specified by outputDirectory configuration parameter: " + retval.getPath());
        }
        String tagPath = this.tagPath;
        if (!(retval = new File(retval, tagPath)).exists() && !retval.mkdirs()) {
            throw new MojoExecutionException("Unable to create the directory specified by tagPath configuration parameter: " + retval.getPath());
        }
        Object tagName = this.tagName;
        if (tagName == null) {
            tagName = "swid-tag";
        }
        switch (tagFormat = this.getTagFormat()) {
            case "XML": {
                tagName = (String)tagName + ".xml";
                break;
            }
            case "CBOR": {
                tagName = (String)tagName + ".cbor";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid tag format '" + tagFormat + "'. Must be one of: XML or CBOR.");
            }
        }
        retval = new File(retval, (String)tagName);
        return retval;
    }

    public String getTagFormat() {
        String retval = this.tagFormat;
        if (retval == null) {
            retval = "XML";
        }
        return retval;
    }

    protected OutputHandler getOutputHander() {
        String tagFormat = this.getTagFormat();
        XMLOutputHandler retval = null;
        switch (tagFormat) {
            case "XML": {
                retval = new XMLOutputHandler();
                break;
            }
            case "CBOR": {
                retval = new CBOROutputHandler();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid output handeler type '" + tagFormat + "'. Must be one of: XML or CBOR.");
            }
        }
        return retval;
    }

    public void execute() throws MojoExecutionException {
        SWIDBuilder builder;
        List<FileEntry> swidFiles;
        String swidPath = "META-INF/" + this.tagPath + "/" + this.tagName;
        ResourceFileEntryProcessor processor = new ResourceFileEntryProcessor(this.project.getBuild().getOutputDirectory(), this.getLog());
        processor.setIncludes(this.getIncludes());
        processor.setExcludes(this.getExcludes());
        try {
            swidFiles = processor.process(this.project.getBuild().getResources());
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occured while processing build files", (Exception)e);
        }
        for (FileEntry entry : swidFiles) {
            this.getLog().debug((CharSequence)("Found file: " + entry.getPath() + " as: " + entry.getOutputRelativePath()));
        }
        try {
            builder = MavenProjectSwidBuilderHelper.buildSwidTag(this.project, swidPath, this.entities, swidFiles);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("A requested hash algorithm is not supported.", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read file while building a SWID tag.", (Exception)e);
        }
        File tagFile = this.getSwidTagFile();
        OutputHandler outputHandler = this.getOutputHander();
        try {
            outputHandler.write(builder, (OutputStream)new BufferedOutputStream(new FileOutputStream(tagFile)));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write tag", (Exception)e);
        }
        catch (ValidationException e) {
            throw new MojoExecutionException("The generated tag was found to be invalid", (Exception)((Object)e));
        }
    }
}

