/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.swid.plugin;

import gov.nist.secauto.swid.builder.SWIDBuilder;
import gov.nist.secauto.swid.builder.ValidationException;
import gov.nist.secauto.swid.builder.output.XMLOutputHandler;
import gov.nist.secauto.swid.plugin.entry.FileEntry;
import gov.nist.secauto.swid.plugin.entry.archive.ArchiveEntryFileEntryProcessor;
import gov.nist.secauto.swid.plugin.generate.MavenProjectSwidBuilderHelper;
import gov.nist.secauto.swid.plugin.model.Entity;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.logging.Logger;

@Component(role=ContainerDescriptorHandler.class, hint="swid-generator", instantiationStrategy="per-lookup")
public class SwidContainerDescriptorHandler
implements ContainerDescriptorHandler {
    private static final List<String> DEFAULT_INCLUDES = Collections.singletonList("**/**");
    private static final String DEFAULT_TAG_PATH = "SWIDTAG";
    private static final String DEFAULT_TAG_NAME = "swid-tag.xml";
    @Requirement
    private MavenProject project;
    @Requirement
    private Logger logger;
    @Parameter(defaultValue="${project.build.directory}/generated-swid", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="SWIDTAG", required=true)
    private String tagPath;
    @Parameter(defaultValue="swid-tag.xml", required=true)
    private String tagName;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<Entity> entities;

    public String[] getIncludes() {
        List<String> retval = this.includes != null && !this.includes.isEmpty() ? this.includes : DEFAULT_INCLUDES;
        return retval.toArray(new String[retval.size()]);
    }

    public String[] getExcludes() {
        List<String> retval = this.excludes != null && !this.excludes.isEmpty() ? this.excludes : Collections.emptyList();
        return retval.toArray(new String[retval.size()]);
    }

    public File getTagOutputDirectory() {
        return this.outputDirectory == null ? new File(this.project.getBuild().getDirectory(), "generated-swid") : this.outputDirectory;
    }

    public String getTagPath() {
        return this.tagPath == null ? DEFAULT_TAG_PATH : this.tagPath;
    }

    public String getTagName() {
        return this.tagName == null ? DEFAULT_TAG_NAME : this.tagName;
    }

    protected File getSwidTagFile() throws ArchiverException {
        File retval = this.getTagOutputDirectory();
        if (!retval.exists() && !retval.mkdirs()) {
            throw new ArchiverException("Unable to create the directory specified by outputDirectory configuration parameter: " + retval.getPath());
        }
        String tagName = this.getTagName();
        retval = new File(retval, tagName);
        return retval;
    }

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        SWIDBuilder builder;
        List<FileEntry> swidFiles;
        DefaultLog log = new DefaultLog(this.logger);
        ArchiveEntryFileEntryProcessor processor = new ArchiveEntryFileEntryProcessor(this.project, (Log)log);
        processor.setIncludes(this.getIncludes());
        processor.setExcludes(this.getExcludes());
        try {
            LinkedList entries = new LinkedList();
            archiver.getResources().forEachRemaining(ae -> entries.add(ae));
            swidFiles = processor.process(entries);
        }
        catch (IOException e) {
            throw new ArchiverException("An error occured while processing build files", (Throwable)e);
        }
        for (FileEntry entry : swidFiles) {
            log.debug((CharSequence)("Found file: " + entry.getPath() + " as: " + entry.getOutputRelativePath()));
        }
        String archiveLocation = this.getTagPath() + File.separator + this.getTagName();
        try {
            builder = MavenProjectSwidBuilderHelper.buildSwidTag(this.project, archiveLocation, this.entities, swidFiles);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ArchiverException("A requested hash algorithm is not supported.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Unable to read file while building a SWID tag.", (Throwable)e);
        }
        File tagFile = this.getSwidTagFile();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tagFile));){
            XMLOutputHandler handler = new XMLOutputHandler();
            handler.write(builder, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new ArchiverException(e.getMessage());
        }
        catch (IOException e) {
            throw new ArchiverException(e.getMessage());
        }
        catch (ValidationException e) {
            throw new ArchiverException(e.getMessage());
        }
        log.info((CharSequence)("Adding tag to archive: " + tagFile.getAbsolutePath()));
        archiver.addFile(tagFile, archiveLocation);
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) throws ArchiverException {
    }

    public List<?> getVirtualFiles() {
        return null;
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        return true;
    }
}

