/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.archiver;

import gov.nist.isg.archiver.FilesArchiver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarArchiver
implements FilesArchiver {
    private final TarArchiveOutputStream tarOutput;

    protected TarArchiver(TarArchiveOutputStream tarOutput) {
        this.tarOutput = tarOutput;
    }

    public TarArchiver(File tarFile) throws FileNotFoundException {
        this(new TarArchiveOutputStream((OutputStream)new FileOutputStream(tarFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T appendFile(String path, FilesArchiver.FileAppender<T> appender) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object result = appender.append((OutputStream)baos);
        TarArchiveEntry entry = new TarArchiveEntry(path);
        entry.setSize((long)baos.size());
        TarArchiver tarArchiver = this;
        synchronized (tarArchiver) {
            this.tarOutput.putArchiveEntry((ArchiveEntry)entry);
            this.tarOutput.write(baos.toByteArray());
            this.tarOutput.closeArchiveEntry();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T appendBigFile(String path, FilesArchiver.FileAppender<T> appender) throws IOException {
        File tempFile = File.createTempFile("tarArchiver", ".tmp");
        try {
            Object result;
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                result = appender.append((OutputStream)fos);
            }
            this.appendFile(path, tempFile);
            Object object = result;
            return (T)object;
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendFile(String path, File file) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(file, path);
        TarArchiver tarArchiver = this;
        synchronized (tarArchiver) {
            this.tarOutput.putArchiveEntry((ArchiveEntry)entry);
            try (FileInputStream fis = new FileInputStream(file);){
                IOUtils.copy((InputStream)fis, (OutputStream)this.tarOutput);
            }
            this.tarOutput.closeArchiveEntry();
        }
    }

    public synchronized void close() throws IOException {
        this.tarOutput.close();
    }
}

