/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.common.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class TimeUtil {
    private static AtomicReference<Long> FIXED_TIME = new AtomicReference();

    private TimeUtil() {
    }

    public static Date getCurrentDate() {
        return new Date(TimeUtil.getCurrentTimeMillis());
    }

    public static long getCurrentTimeMillis() {
        return TimeUtil.getCurrentTime(TimeUnit.MILLISECONDS);
    }

    public static long getCurrentTime(TimeUnit tu) {
        Long setTime = FIXED_TIME.get();
        if (setTime == null) {
            setTime = System.currentTimeMillis() * 1000000L;
        }
        return tu.convert(setTime, TimeUnit.NANOSECONDS);
    }

    public static void setCurrentTime(long time, TimeUnit tu) {
        FIXED_TIME.set(TimeUnit.NANOSECONDS.convert(time, tu));
    }

    public static void setCurrentTime(long timeMillis) {
        TimeUtil.setCurrentTime(timeMillis, TimeUnit.MILLISECONDS);
    }

    public static void setCurrentTime(Date date) {
        TimeUtil.setCurrentTime(date.getTime());
    }

    public static void useSystemTime() {
        FIXED_TIME.set(null);
    }

    public static Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month - 1, day);
        return c.getTime();
    }

    public static LocalDate getCurrentLocalDate() {
        return TimeUtil.asLocalDate(TimeUtil.getCurrentDate());
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return TimeUtil.asLocalDateTime(TimeUtil.getCurrentDate());
    }

    public static LocalDate asLocalDate(Date date) {
        return TimeUtil.asLocalDate(date, ZoneId.systemDefault());
    }

    public static LocalDate asLocalDate(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            return ((java.sql.Date)date).toLocalDate();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return TimeUtil.asLocalDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime asLocalDateTime(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return ((Timestamp)date).toLocalDateTime();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDateTime();
    }

    public static long toMillis(LocalDateTime localDateTime) {
        return TimeUtil.toMillis(localDateTime, ZoneId.systemDefault());
    }

    public static long toMillis(LocalDateTime localDateTime, ZoneId zone) {
        return localDateTime.atZone(zone).toInstant().toEpochMilli();
    }
}

